/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

public final class UriUtil {
    private static final String ESCAPE_CHARS = "<>%\"{}|\\^[]`";

    public static String encodeUri(String uri) {
        StringBuilder result = new StringBuilder();
        UriUtil.encodeUri(uri, result);
        return result.toString();
    }

    public static void encodeUri(String uri, StringBuilder buffer) {
        int length = uri.length();
        for (int i = 0; i < length; ++i) {
            char c;
            char cInt = c = uri.charAt(i);
            if (ESCAPE_CHARS.indexOf(c) >= 0 || cInt <= ' ') {
                buffer.append('%');
                String hexVal = Integer.toHexString(cInt);
                if (hexVal.length() == 1) {
                    buffer.append('0');
                }
                buffer.append(hexVal);
                continue;
            }
            buffer.append(c);
        }
    }

    public static String decodeUri(String uri) {
        StringBuilder result = new StringBuilder();
        UriUtil.decodeUri(uri, result);
        return result.toString();
    }

    public static void decodeUri(String uri, StringBuilder buffer) {
        int percentIdx = uri.indexOf(37);
        int startIdx = 0;
        while (percentIdx != -1) {
            buffer.append(uri.substring(startIdx, percentIdx));
            String xx = uri.substring(percentIdx + 1, percentIdx + 3);
            buffer.append((char)Integer.parseInt(xx, 16));
            startIdx = percentIdx + 3;
            percentIdx = uri.indexOf(37, startIdx);
        }
        buffer.append(uri.substring(startIdx));
    }
}

