/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.math.BigInteger;
import java.security.MessageDigest;

public class StringUtil {
    public static String replace(String olds, String news, String text) {
        if (olds == null || olds.length() == 0) {
            return text;
        }
        if (text == null) {
            return null;
        }
        int oldsIndex = text.indexOf(olds);
        if (oldsIndex == -1) {
            return text;
        }
        StringBuilder buffer = new StringBuilder(text.length());
        int prevIndex = 0;
        while (oldsIndex >= 0) {
            buffer.append(text.substring(prevIndex, oldsIndex));
            buffer.append(news);
            prevIndex = oldsIndex + olds.length();
            oldsIndex = text.indexOf(olds, prevIndex);
        }
        buffer.append(text.substring(prevIndex));
        return buffer.toString();
    }

    public static String sha1Hash(String string) {
        try {
            return StringUtil.sha1Hash(string.getBytes());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String sha1Hash(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(bytes);
            byte[] digest = md.digest();
            BigInteger integer = new BigInteger(1, digest);
            return integer.toString(16);
        }
        catch (Exception e) {
            return null;
        }
    }
}

