/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;

public class RegistryReader {
    private static final String REGSTR_TOKEN = "REG_SZ";
    private static final String REGDWORD_TOKEN = "REG_DWORD";
    private static final String REGQUERY_UTIL = "Reg Query ";
    private static final String REGKEY_SHELLFOLDERS = "\"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\"";
    private static final String PERSONAL_FOLDER_CMD = "Reg Query \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\" /v Personal";
    private static final String APP_DATA_CMD = "Reg Query \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\" /v AppData";
    private static final String LOCALSETTINGS_CMD = "Reg Query \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\" /v \"Local Settings\"";
    private static final String LOCALAPPDATA_CMD = "Reg Query \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\" /v \"Local AppData\"";

    public static String getCurrentUserPersonalFolderPath() {
        return RegistryReader.runCommand(PERSONAL_FOLDER_CMD);
    }

    public static String getCurrentUserAppDataFolderPath() {
        return RegistryReader.runCommand(APP_DATA_CMD);
    }

    public static String getCurrentUserLocalSettingsFolderPath() {
        return RegistryReader.runCommand(LOCALSETTINGS_CMD);
    }

    public static String getCurrentUserLocalAppDataFolderPath() {
        return RegistryReader.runCommand(LOCALAPPDATA_CMD);
    }

    private static String runCommand(String command) {
        if (!System.getProperty("os.name").toLowerCase().contains("windows")) {
            return null;
        }
        try {
            Process process = Runtime.getRuntime().exec(command);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String result = reader.getResult();
            int p = result.indexOf(REGSTR_TOKEN);
            if (p == -1) {
                return null;
            }
            return result.substring(p + REGSTR_TOKEN.length()).trim();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println("Your My Documents Folder is In: " + RegistryReader.getCurrentUserPersonalFolderPath());
        System.out.println("Your AppData Folder is In: " + RegistryReader.getCurrentUserAppDataFolderPath());
        System.out.println("Your Local Settings Folder is In: " + RegistryReader.getCurrentUserLocalSettingsFolderPath());
        System.out.println("Your Local App Data Folder is In: " + RegistryReader.getCurrentUserLocalAppDataFolderPath());
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw;

        StreamReader(InputStream is) {
            this.is = is;
            this.sw = new StringWriter();
        }

        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        String getResult() {
            return this.sw.toString();
        }
    }
}

