/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class DateUtil {
    private static DateFormat fullDateFormat = null;
    private static DateFormat notzDateFormat = null;
    private static DateFormat plainDateFormat = null;
    private static DatatypeFactory datatypeFactory = null;

    public static String dateTime2String(Date date) {
        long ts = date.getTime();
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTimeInMillis(ts);
        XMLGregorianCalendar cal = DateUtil.getDataTypeFactory().newXMLGregorianCalendar(gcal);
        cal.setMillisecond(0);
        return cal.toXMLFormat();
    }

    public static String date2String(Date date) {
        return DateUtil.getPlainDateFormat().format(date);
    }

    public static Date string2DateTime(String string) throws ParseException {
        Date res = null;
        try {
            XMLGregorianCalendar xcal = DateUtil.getDataTypeFactory().newXMLGregorianCalendar(string);
            xcal.setMillisecond(0);
            return xcal.toGregorianCalendar().getTime();
        }
        catch (IllegalArgumentException pe) {
            res = DateUtil.getISO8601DateFormat().parse(string);
            return res;
        }
    }

    public static Date string2Date(String string) throws ParseException {
        return DateUtil.getPlainDateFormat().parse(string);
    }

    public static String string2UTCString(String string) throws ParseException {
        Date date = DateUtil.string2DateTime(string);
        return DateUtil.dateTime2UTCString(date);
    }

    public static String dateTime2UTCString(Date date) {
        Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.UK);
        utcCalendar.setTimeInMillis(date.getTime());
        return utcCalendar.get(1) + "-" + DateUtil.zeroPad(utcCalendar.get(2) + 1) + "-" + DateUtil.zeroPad(utcCalendar.get(5)) + "T" + DateUtil.zeroPad(utcCalendar.get(11)) + ":" + DateUtil.zeroPad(utcCalendar.get(12)) + ":" + DateUtil.zeroPad(utcCalendar.get(13)) + "Z";
    }

    public static boolean dateTimeStringEqualToUTCString(String dateTimeString, String utcString) throws ParseException {
        return utcString.equals(DateUtil.string2UTCString(dateTimeString));
    }

    public static boolean dateTimeEqualToUTCString(Date dateTime, String utcString) {
        return utcString.equals(DateUtil.dateTime2UTCString(dateTime));
    }

    private static String zeroPad(long i) {
        if (i >= 0L && i <= 9L) {
            return "0" + i;
        }
        return String.valueOf(i);
    }

    public static DateFormat getISO8601DateFormat() {
        if (fullDateFormat == null) {
            fullDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        }
        return fullDateFormat;
    }

    public static DateFormat getISO8601DateFormatNoTimezone() {
        if (notzDateFormat == null) {
            notzDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        }
        return notzDateFormat;
    }

    public static DateFormat getPlainDateFormat() {
        if (plainDateFormat == null) {
            plainDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        }
        return plainDateFormat;
    }

    private static DatatypeFactory getDataTypeFactory() {
        if (datatypeFactory == null) {
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                e.printStackTrace();
            }
        }
        return datatypeFactory;
    }
}

