/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.textpipe.annotators;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import org.openimaj.text.nlp.textpipe.annotations.RawTextAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.TokenAnnotation;
import org.openimaj.text.nlp.textpipe.annotators.AbstractTokenAnnotator;
import org.openimaj.text.nlp.textpipe.annotators.MissingRequiredAnnotationException;

public class OpenNLPTokenAnnotator
extends AbstractTokenAnnotator {
    public static final String TOKEN_MODEL_PROP = "org.openimaj.text.opennlp.models.token";
    private static final String TOKEN_MODEL_DEFAULT = "/org/openimaj/text/opennlp/models/en-token.bin";
    TokenizerME tokenizer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenNLPTokenAnnotator() {
        InputStream modelIn = null;
        modelIn = OpenNLPTokenAnnotator.class.getResourceAsStream(System.getProperty(TOKEN_MODEL_PROP, TOKEN_MODEL_DEFAULT));
        TokenizerModel model = null;
        try {
            model = new TokenizerModel(modelIn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (modelIn != null) {
                try {
                    modelIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.tokenizer = new TokenizerME(model);
    }

    @Override
    void checkForRequiredAnnotations(RawTextAnnotation annotation) throws MissingRequiredAnnotationException {
    }

    @Override
    public List<TokenAnnotation> tokenise(String text) {
        ArrayList<TokenAnnotation> tla = new ArrayList<TokenAnnotation>();
        int currentOff = 0;
        for (String token : this.tokenizer.tokenize(text)) {
            int start = currentOff + text.substring(currentOff).indexOf(token);
            int stop = start + token.length();
            tla.add(new TokenAnnotation(token, text.substring(currentOff, stop), start, stop));
            currentOff = stop;
        }
        return tla;
    }
}

