/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.textpipe.annotators;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import org.openimaj.text.nlp.textpipe.annotations.RawTextAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.SentenceAnnotation;
import org.openimaj.text.nlp.textpipe.annotators.AbstractSentenceAnnotator;
import org.openimaj.text.nlp.textpipe.annotators.MissingRequiredAnnotationException;

public class OpenNLPSentenceAnnotator
extends AbstractSentenceAnnotator {
    public static final String SENTENCE_MODEL_PROP = "org.openimaj.text.opennlp.models.sent";
    public static final String SENTENCE_MODEL_DEFAULT = "/org/openimaj/text/opennlp/models/en-sent.bin";
    SentenceDetectorME sentenceDetector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenNLPSentenceAnnotator() {
        InputStream modelIn = null;
        modelIn = OpenNLPSentenceAnnotator.class.getResourceAsStream(System.getProperty(SENTENCE_MODEL_PROP, SENTENCE_MODEL_DEFAULT));
        SentenceModel model = null;
        try {
            model = new SentenceModel(modelIn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (modelIn != null) {
                try {
                    modelIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.sentenceDetector = new SentenceDetectorME(model);
    }

    @Override
    protected List<SentenceAnnotation> getSentenceAnnotations(String text) {
        ArrayList<SentenceAnnotation> sents = new ArrayList<SentenceAnnotation>();
        List<String> sentences = Arrays.asList(this.sentenceDetector.sentDetect(text));
        boolean currentOff = false;
        for (int i = 0; i < sentences.size(); ++i) {
            String sentence = sentences.get(i);
            int start = 0 + text.substring(0).indexOf(sentence);
            int stop = start + sentence.length();
            sents.add(new SentenceAnnotation(sentence, start, stop));
        }
        return sents;
    }

    @Override
    void checkForRequiredAnnotations(RawTextAnnotation annotation) throws MissingRequiredAnnotationException {
    }
}

