/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.textpipe.annotators;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerME;
import org.openimaj.text.nlp.textpipe.annotations.POSAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.RawTextAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.SentenceAnnotation;
import org.openimaj.text.nlp.textpipe.annotators.AbstractPOSAnnotator;
import org.openimaj.text.nlp.textpipe.annotators.MissingRequiredAnnotationException;

public class OpenNLPPOSAnnotator
extends AbstractPOSAnnotator {
    public static final String POS_MODEL_PROP = "org.openimaj.text.opennlp.models.pos";
    public static final String POS_MODEL_DEFAULT = "/org/openimaj/text/opennlp/models/en-pos-maxent.bin";
    POSTaggerME tagger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenNLPPOSAnnotator() {
        InputStream modelIn = null;
        POSModel model = null;
        try {
            modelIn = OpenNLPPOSAnnotator.class.getResourceAsStream(System.getProperty(POS_MODEL_PROP, POS_MODEL_DEFAULT));
            model = new POSModel(modelIn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (modelIn != null) {
                try {
                    modelIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.tagger = new POSTaggerME(model);
    }

    @Override
    public void annotate(RawTextAnnotation annotation) throws MissingRequiredAnnotationException {
        if (!annotation.getAnnotationKeyList().contains(SentenceAnnotation.class)) {
            throw new MissingRequiredAnnotationException("No SentenceAnnotations found : OpenNLPPOSAnnotator requires sentance splitting");
        }
        super.annotate(annotation);
    }

    @Override
    protected List<POSAnnotation.PartOfSpeech> pos(List<String> tokenList) {
        ArrayList<POSAnnotation.PartOfSpeech> result = new ArrayList<POSAnnotation.PartOfSpeech>();
        String[] p = null;
        String[] sentence = new String[tokenList.size()];
        for (int i = 0; i < sentence.length; ++i) {
            sentence[i] = tokenList.get(i);
        }
        for (String pos : p = this.tagger.tag(sentence)) {
            if (POSAnnotation.PartOfSpeech.getPOSfromString(pos) == null) {
                System.out.println("no matching pos " + pos);
            }
            result.add(POSAnnotation.PartOfSpeech.getPOSfromString(pos));
        }
        return result;
    }

    @Override
    void checkForRequiredAnnotations(RawTextAnnotation annotation) throws MissingRequiredAnnotationException {
    }
}

