/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.sentiment.type;

import java.util.HashMap;
import java.util.Map;
import org.openimaj.text.nlp.sentiment.type.BipolarSentiment;
import org.openimaj.text.nlp.sentiment.type.BipolarSentimentProvider;
import org.openimaj.text.nlp.sentiment.type.Sentiment;
import org.openimaj.text.nlp.sentiment.type.UnrecognisedMapException;
import org.openimaj.util.math.ObjectArithmetic;
import org.openimaj.util.math.ScalarArithmetic;

public class WeightedBipolarSentiment
implements Sentiment,
BipolarSentimentProvider,
ScalarArithmetic<WeightedBipolarSentiment, Double>,
ObjectArithmetic<WeightedBipolarSentiment> {
    private double positive;
    private double negative;
    private double neutral;

    public WeightedBipolarSentiment() {
    }

    public WeightedBipolarSentiment(double positive, double negative, double neutral) {
        this.positive = positive;
        this.negative = negative;
        this.neutral = neutral;
    }

    public double positive() {
        return this.positive;
    }

    public double negative() {
        return this.negative;
    }

    public double neutral() {
        return this.neutral;
    }

    @Override
    public BipolarSentiment bipolar() {
        if (this.positive > this.negative) {
            if (this.positive > this.neutral) {
                return BipolarSentiment.POSITIVE;
            }
            return BipolarSentiment.NEUTRAL;
        }
        if (this.negative > this.neutral) {
            return BipolarSentiment.NEGATIVE;
        }
        return BipolarSentiment.NEUTRAL;
    }

    @Override
    public BipolarSentiment bipolar(double deltaThresh) {
        if (this.positive > this.negative * deltaThresh) {
            if (this.positive > this.neutral * deltaThresh) {
                return BipolarSentiment.POSITIVE;
            }
            if (this.neutral > this.positive * deltaThresh) {
                return BipolarSentiment.NEUTRAL;
            }
        } else {
            if (this.negative > this.neutral * deltaThresh) {
                return BipolarSentiment.NEGATIVE;
            }
            if (this.neutral > this.negative * deltaThresh) {
                return BipolarSentiment.NEUTRAL;
            }
        }
        return null;
    }

    @Override
    public Map<String, ?> asMap() {
        HashMap<String, Double> ret = new HashMap<String, Double>();
        ret.put("positive", this.positive);
        ret.put("negative", this.negative);
        ret.put("neutral", this.neutral);
        return ret;
    }

    @Override
    public void fromMap(Map<String, ?> map) throws UnrecognisedMapException {
        if (!(map.containsKey("positive") && map.containsKey("negative") && map.containsKey("neutral"))) {
            throw new UnrecognisedMapException("positive", "negative", "neutral");
        }
        this.positive = (Double)map.get("positive");
        this.negative = (Double)map.get("negative");
        this.neutral = (Double)map.get("neutral");
    }

    public String toString() {
        String out = "+(%.4f),-(%.4f),~(%.4f)";
        return String.format("+(%.4f),-(%.4f),~(%.4f)", this.positive, this.negative, this.neutral);
    }

    public WeightedBipolarSentiment addInplace(WeightedBipolarSentiment that) {
        this.negative += that.negative;
        this.positive += that.positive;
        this.neutral += that.neutral;
        return this;
    }

    public WeightedBipolarSentiment add(WeightedBipolarSentiment that) {
        return this.clone().add(that);
    }

    public WeightedBipolarSentiment divide(WeightedBipolarSentiment that) {
        return this.clone().divideInplace(that);
    }

    public WeightedBipolarSentiment divideInplace(WeightedBipolarSentiment that) {
        this.negative /= that.negative;
        this.neutral /= that.neutral;
        this.positive /= that.positive;
        return this;
    }

    public WeightedBipolarSentiment clone() {
        return new WeightedBipolarSentiment(this.positive, this.negative, this.neutral);
    }

    public double total() {
        return this.negative + this.neutral + this.positive;
    }

    public WeightedBipolarSentiment add(Double f) {
        return this.clone().addInplace(f);
    }

    public WeightedBipolarSentiment addInplace(Double f) {
        this.negative += f.doubleValue();
        this.positive += f.doubleValue();
        this.neutral += f.doubleValue();
        return this;
    }

    public WeightedBipolarSentiment divide(Double d) {
        return this.clone().divideInplace(d);
    }

    public WeightedBipolarSentiment divideInplace(Double d) {
        this.negative /= d.doubleValue();
        this.neutral /= d.doubleValue();
        this.positive /= d.doubleValue();
        return this;
    }

    public WeightedBipolarSentiment subtract(WeightedBipolarSentiment s) {
        return this.clone().subtractInplace(s);
    }

    public WeightedBipolarSentiment subtractInplace(WeightedBipolarSentiment f) {
        this.negative -= f.negative;
        this.positive -= f.positive;
        this.neutral -= f.neutral;
        return this;
    }

    public WeightedBipolarSentiment multiply(WeightedBipolarSentiment that) {
        return this.clone().multiplyInplace(that);
    }

    public WeightedBipolarSentiment multiplyInplace(WeightedBipolarSentiment that) {
        this.negative *= that.negative;
        this.neutral *= that.neutral;
        this.positive *= that.positive;
        return this;
    }

    public WeightedBipolarSentiment multiply(Double value) {
        return this.clone().multiplyInplace(value);
    }

    public WeightedBipolarSentiment multiplyInplace(Double value) {
        this.negative *= value.doubleValue();
        this.neutral *= value.doubleValue();
        this.positive *= value.doubleValue();
        return this;
    }

    public WeightedBipolarSentiment subtract(Double s) {
        return this.add(-s.doubleValue());
    }

    public WeightedBipolarSentiment subtractInplace(Double s) {
        return this.addInplace(-s.doubleValue());
    }

    public boolean containsNaN() {
        return new Double(this.negative).isNaN() || new Double(this.neutral).isNaN() || new Double(this.positive).isNaN();
    }

    public WeightedBipolarSentiment logInplace() {
        if (this.negative > 0.0) {
            this.negative = Math.log(this.negative);
        }
        if (this.positive > 0.0) {
            this.positive = Math.log(this.positive);
        }
        if (this.neutral > 0.0) {
            this.neutral = Math.log(this.neutral);
        }
        return this;
    }

    public void neutral(double neutral) {
        this.neutral = neutral;
    }

    public void negative(double negative) {
        this.negative = negative;
    }

    public void positive(double positive) {
        this.positive = positive;
    }

    public void correctNaN(double d) {
        if (new Double(this.negative).isNaN()) {
            this.negative = d;
        }
        if (new Double(this.positive).isNaN()) {
            this.positive = d;
        }
        if (new Double(this.neutral).isNaN()) {
            this.neutral = d;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WeightedBipolarSentiment)) {
            return false;
        }
        WeightedBipolarSentiment that = (WeightedBipolarSentiment)obj;
        return this.negative == that.negative && this.positive == that.positive && this.neutral == that.neutral;
    }

    public WeightedBipolarSentiment expInplace() {
        this.negative = Math.exp(this.negative);
        this.positive = Math.exp(this.positive);
        this.neutral = Math.exp(this.neutral);
        return this;
    }

    public WeightedBipolarSentiment clipMaxInplace(double d) {
        if (this.negative > d) {
            this.negative = d;
        }
        if (this.positive > d) {
            this.positive = d;
        }
        if (this.neutral > d) {
            this.neutral = d;
        }
        return this;
    }
}

