/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.sentiment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openimaj.text.nlp.sentiment.SentimentExtractor;

public class BillMPQASentiment
extends SentimentExtractor {
    private String mpqaN = "/org/openimaj/text/nlp/sentiment/mpqan.txt";
    private String mpqaP = "/org/openimaj/text/nlp/sentiment/mpqap.txt";

    @Override
    public Map<String, Object> extract(List<String> strings) {
        HashSet<String> mpqaPSet = this.readSentiSet(this.mpqaP);
        HashSet<String> mpqaNSet = this.readSentiSet(this.mpqaN);
        HashMap<String, Object> output = new HashMap<String, Object>();
        HashSet<String> positiveWords = new HashSet<String>();
        HashSet<String> negativeWords = new HashSet<String>();
        int countP = 0;
        int countN = 0;
        for (String string : strings) {
            if (mpqaPSet.contains(string)) {
                ++countP;
                positiveWords.add(string);
                continue;
            }
            if (!mpqaNSet.contains(string)) continue;
            ++countN;
            negativeWords.add(string);
        }
        output.put("sentiment", countP - countN);
        output.put("sentiment_positive", countP);
        output.put("sentiment_negative", countN);
        output.put("positive_words", positiveWords);
        output.put("negative_words", negativeWords);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<String> readSentiSet(String filepath) {
        HashSet<String> sentiSet = new HashSet<String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(SentimentExtractor.class.getResourceAsStream(filepath)));
        }
        catch (Exception ex) {
            Logger.getLogger(SentimentExtractor.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            String line = br.readLine();
            while (line != null) {
                sentiSet.add(line.trim());
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SentimentExtractor.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ex) {
                Logger.getLogger(SentimentExtractor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return sentiSet;
    }
}

