/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.patterns;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.openimaj.text.nlp.patterns.PatternProvider;
import org.openimaj.text.nlp.patterns.PunctuationPatternProvider;

public abstract class EdgePunctuationPatternProvider
extends PatternProvider {
    protected String EdgePunct;
    protected String NotEdgePunct;
    protected String StartPunc;
    protected String EndPunc;
    static PunctuationPatternProvider punctuation = new PunctuationPatternProvider();
    static EdgePunctuationPatternProvider edgeleft = new Left(punctuation);
    static EdgePunctuationPatternProvider edgeright = new Right(punctuation);

    /*
     * WARNING - void declaration
     */
    public EdgePunctuationPatternProvider(PunctuationPatternProvider punctuation) {
        void var7_10;
        Object[] EdgePunctArr = new String[]{"'", "\"", "\\*", "\u201c", "\u201d", "\u2018", "\u2019", "\\<", "\\>", "\u00ab", "\u00bb", "{", "}", "\\(", "\\)", "\\[", "\\]", "\\\\", "\\|"};
        HashSet<String> edgeSet = new HashSet<String>();
        for (String string : EdgePunctArr) {
            edgeSet.add(string);
        }
        this.EdgePunct = "[" + StringUtils.join((Object[])EdgePunctArr, (String)"") + "]";
        ArrayList<String> puncArr = new ArrayList<String>();
        String[] stringArray = punctuation.PunctCharsList;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_10 < n) {
            String punc = stringArray[var7_10];
            if (!edgeSet.contains(punc)) {
                puncArr.add(punc);
            }
            ++var7_10;
        }
        this.NotEdgePunct = "(?:[a-zA-Z0-9]|[" + StringUtils.join(puncArr, (String)"") + "\\-])";
        this.StartPunc = "\\s|^|[.,]|[a-zA-Z0-9]";
        this.EndPunc = "\\s|$|[.,]|[a-zA-Z0-9]";
    }

    public static String edgePuncPattern() {
        return new EdgePunctuationPatternProvider((PunctuationPatternProvider)new PunctuationPatternProvider()){

            @Override
            public String correctEdges(String s) {
                return null;
            }

            @Override
            public String patternString() {
                return null;
            }
        }.EdgePunct;
    }

    public abstract String correctEdges(String var1);

    public static String fixedges(String text) {
        String s = text;
        s = edgeleft.correctEdges(s);
        s = edgeright.correctEdges(s);
        return s;
    }

    public static class Right
    extends EdgePunctuationPatternProvider {
        protected String EdgePunctRight;

        public Right(PunctuationPatternProvider punctuation) {
            super(punctuation);
            this.EdgePunctRight = String.format("(%s)(%s+)(%s)", this.NotEdgePunct, this.EdgePunct, this.EndPunc);
        }

        @Override
        public String patternString() {
            return this.EdgePunctRight;
        }

        @Override
        public String correctEdges(String s) {
            String ret = this.pattern().matcher(s).replaceAll("$1 $2$3");
            return ret;
        }
    }

    public static class Left
    extends EdgePunctuationPatternProvider {
        protected String EdgePunctLeft;

        public Left(PunctuationPatternProvider punctuation) {
            super(punctuation);
            this.EdgePunctLeft = String.format("(%s)(%s+)(%s)", this.StartPunc, this.EdgePunct, this.NotEdgePunct);
        }

        @Override
        public String patternString() {
            return this.EdgePunctLeft;
        }

        @Override
        public String correctEdges(String s) {
            return this.pattern().matcher(s).replaceAll("$1$2 $3");
        }
    }
}

