/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.namedentity;

import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public class YagoQueryUtils {
    private static String PREFIX = "PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#> ";
    public static String YAGO_SPARQL_ENDPOINT = "http://lod.openlinksw.com/sparql";
    public static String WORDNET_ORGANISATION_URI = "http://yago-knowledge.org/resource/wordnet_organization_108008335";
    public static String WORDNET_ENTERPRISE_URI = "http://yago-knowledge.org/resource/wordnet_enterprise_108056231";
    public static String WORDNET_COMPANY_URI = "http://yago-knowledge.org/resource/wordnet_company_108058098";
    public static String[] WORDNET_ORGANISATION_ROOT_URIS = new String[]{"http://yago-knowledge.org/resource/wordnet_adhocracy_108009239", "http://yago-knowledge.org/resource/wordnet_affiliate_108009478", "http://yago-knowledge.org/resource/wordnet_bureaucracy_108009659", "http://yago-knowledge.org/resource/wordnet_nongovernmental_organization_108009834", "http://yago-knowledge.org/resource/wordnet_association_108049401", "http://yago-knowledge.org/resource/wordnet_polity_108050385", "http://yago-knowledge.org/resource/wordnet_quango_108050484", "http://yago-knowledge.org/resource/wordnet_institution_108053576", "http://yago-knowledge.org/resource/wordnet_enterprise_108056231", "http://yago-knowledge.org/resource/wordnet_defense_108064130", "http://yago-knowledge.org/resource/wordnet_establishment_108075847", "http://yago-knowledge.org/resource/wordnet_company_108187033", "http://yago-knowledge.org/resource/wordnet_union_108233056", "http://yago-knowledge.org/resource/wordnet_party_108256968", "http://yago-knowledge.org/resource/wordnet_professional_organization_108266070", "http://yago-knowledge.org/resource/wordnet_alliance_108293982", "http://yago-knowledge.org/resource/wordnet_federation_108303504"};

    public static String isCalledAlliasQuery(String companyURI) {
        return PREFIX + "SELECT ?alias WHERE {?fact rdf:predicate <http://yago-knowledge.org/resource/isCalled> .?fact rdf:object   ?alias .?fact rdf:subject <" + companyURI + "> }";
    }

    public static String labelAlliasQuery(String companyURI) {
        return PREFIX + "SELECT ?alias WHERE { <" + companyURI + "> rdfs:label ?alias .}";
    }

    public static String wordnetCompanyQuery() {
        return PREFIX + "SELECT ?company WHERE { ?company rdf:type <" + WORDNET_COMPANY_URI + "> . }";
    }

    public static String subClassWordnetCompanyQuery() {
        return PREFIX + "SELECT ?company WHERE { ?subclass rdfs:subClassOf <" + WORDNET_COMPANY_URI + "> .  ?company rdf:type ?subclass . }";
    }

    public static String ownsContextQuery(String companyURI) {
        return PREFIX + "SELECT ?context WHERE { ?fact rdf:object <" + companyURI + "> . ?fact rdf:predicate owns .?fact rdf:subject ?context}";
    }

    public static String createdContextQuery(String companyURI) {
        return PREFIX + "SELECT ?context WHERE {?fact rdf:subject <" + companyURI + "> . ?fact rdf:predicate <http://yago-knowledge.org/resource/created> .?fact rdf:object ?context}";
    }

    public static String anchorContextQuery(String companyURI) {
        return PREFIX + "SELECT ?context WHERE {<" + companyURI + "> <http://yago-knowledge.org/resource/hasWikipediaAnchorText> ?context }";
    }

    public static String wikiURLContextQuery(String companyURI) {
        return PREFIX + "SELECT ?context WHERE {<" + companyURI + "> <http://yago-knowledge.org/resource/hasWikipediaUrl> ?context }";
    }

    public static String factObjectsQuery(String subjectURI, String predicateURI) {
        return PREFIX + "SELECT ?object WHERE { ?f rdf:subject <" + subjectURI + "> . ?f rdf:predicate " + predicateURI + " . ?f rdf:object ?object}";
    }

    public static String tripleObjectsQuery(String subjectURI, String predicateURI) {
        return PREFIX + "SELECT ?object WHERE { " + subjectURI + " " + predicateURI + " ?object}";
    }

    public static String factSubjectsQuery(String objectURI, String predicateURI) {
        return PREFIX + "SELECT ?subject WHERE { ?f rdf:subject ?subject . ?f rdf:predicate " + predicateURI + " . ?f rdf:object <" + objectURI + ">}";
    }

    public static String tripleSubjectsQuery(String objectURI, String predicateURI) {
        return PREFIX + "SELECT ?subject WHERE { ?subject " + predicateURI + " " + objectURI + "}";
    }

    public static String multiTripleObjectsQuery(Map<String, String> variableNameToPredicate, String subjectUri) {
        StringBuffer sb = new StringBuffer();
        sb.append(PREFIX + "SELECT * WHERE {");
        for (String varName : variableNameToPredicate.keySet()) {
            sb.append("<" + subjectUri + "> " + variableNameToPredicate.get(varName) + " ?" + varName + " . ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static String multiFactObjectsQuery(Map<String, String> variableNameToPredicate, String subjectUri) {
        StringBuffer sb = new StringBuffer();
        sb.append(PREFIX + "SELECT * WHERE {");
        boolean fcount = false;
        for (String varName : variableNameToPredicate.keySet()) {
            sb.append("?fact0 rdf:subject <" + subjectUri + "> . ?fact" + 0 + " rdf:predicate " + variableNameToPredicate.get(varName) + " . ?fact" + 0 + " rdf:object ?" + varName + " . ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static String yagoLiteralToString(String literal) {
        return StringEscapeUtils.unescapeJava((String)literal.substring(0, literal.indexOf("^^http")));
    }

    public static String yagoResourceToString(String resource) {
        return resource.substring(resource.lastIndexOf("/") + 1).replaceAll("_", " ").trim();
    }

    public static void main(String[] args) {
    }
}

