/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.namedentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openimaj.ml.annotation.ScoredAnnotation;
import org.openimaj.text.nlp.namedentity.EntityAnnotator;
import org.openimaj.text.nlp.namedentity.NamedEntity;
import org.openimaj.text.nlp.namedentity.YagoEntityCandidateFinderFactory;
import org.openimaj.text.nlp.namedentity.YagoEntityContextAnnotator;
import org.openimaj.text.nlp.namedentity.YagoEntityContextScorerFactory;

public class YagoEntityCompleteAnnotator
extends EntityAnnotator {
    private YagoEntityContextScorerFactory.YagoEntityContextScorer contextScorer;
    private YagoEntityCandidateFinderFactory.YagoEntityCandidateFinder candidateFinder;
    private int localContextBound = 20;

    public YagoEntityCompleteAnnotator(YagoEntityContextScorerFactory.YagoEntityContextScorer contextScorer, YagoEntityCandidateFinderFactory.YagoEntityCandidateFinder candidateFinder) {
        this.contextScorer = contextScorer;
        this.candidateFinder = candidateFinder;
    }

    public Set<HashMap<String, Object>> getAnnotations() {
        return null;
    }

    public List<ScoredAnnotation<HashMap<String, Object>>> annotate(List<String> tokens) {
        ArrayList<ScoredAnnotation<HashMap<String, Object>>> result = new ArrayList<ScoredAnnotation<HashMap<String, Object>>>();
        List<List<NamedEntity>> candidates = this.candidateFinder.getCandidates(tokens);
        if (candidates.size() == 0) {
            return result;
        }
        for (List<NamedEntity> can : candidates) {
            ArrayList<String> companies = new ArrayList<String>();
            for (NamedEntity ent : can) {
                companies.add(ent.rootName);
            }
            List<String> localContext = this.getLocalContext(tokens, can.get((int)0).startToken, can.get((int)0).stopToken);
            Map<NamedEntity, Float> contextScores = this.contextScorer.getScoresForEntityList((List<String>)companies, localContext);
            float topScore = 0.0f;
            NamedEntity resEntity = null;
            for (NamedEntity entity : can) {
                if (!contextScores.keySet().contains(entity) || !(contextScores.get(entity).floatValue() > topScore)) continue;
                resEntity = entity;
                topScore = contextScores.get(entity).floatValue();
            }
            if (resEntity == null) continue;
            HashMap<String, Object> annotation = new HashMap<String, Object>();
            annotation.put(YagoEntityContextAnnotator.SCORE, Float.valueOf(topScore));
            annotation.put(YagoEntityContextAnnotator.URI, resEntity.rootName);
            annotation.put(YagoEntityContextAnnotator.START_TOKEN, resEntity.startToken);
            annotation.put(YagoEntityContextAnnotator.END_TOKEN, resEntity.stopToken);
            annotation.put(YagoEntityContextAnnotator.TYPE, resEntity.type.toString());
            result.add((ScoredAnnotation<HashMap<String, Object>>)new ScoredAnnotation(annotation, 1.0f));
        }
        return result;
    }

    private List<String> getLocalContext(List<String> tokens, int startToken, int stopToken) {
        int bottom = Math.max(0, startToken - this.localContextBound);
        int top = Math.min(tokens.size(), stopToken + this.localContextBound);
        return tokens.subList(bottom, top);
    }
}

