/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.namedentity;

import com.hp.hpl.jena.query.QuerySolution;
import java.util.ArrayList;
import java.util.HashSet;
import org.openimaj.text.nlp.namedentity.SparqlQueryPager;
import org.openimaj.text.nlp.namedentity.YagoQueryUtils;

public class SparqlTransitiveClosure {
    private final SparqlQueryPager pager;

    public SparqlTransitiveClosure(String endPoint) {
        this.pager = new SparqlQueryPager(endPoint);
    }

    public HashSet<String> getAllTransitiveLeavesOf(String rootEntity, String transitiveRelationship, String leafRelationship) {
        return this.scoureTheTree(rootEntity, transitiveRelationship, leafRelationship);
    }

    private HashSet<String> scoureTheTree(String rootEntity, String transitiveRelationship, String leafRelationship) {
        ArrayList<QuerySolution> subNodes = this.getSubNodes(rootEntity, transitiveRelationship);
        HashSet<String> result = this.getLeaves(rootEntity, leafRelationship);
        for (QuerySolution soln : subNodes) {
            result.addAll(this.scoureTheTree(soln.getResource("subject").getURI(), transitiveRelationship, leafRelationship));
        }
        return result;
    }

    private HashSet<String> getLeaves(String rootEntity, String leafRelationship) {
        HashSet<String> result = new HashSet<String>();
        ArrayList<QuerySolution> pageResults = this.pager.pageQuery(YagoQueryUtils.factSubjectsQuery(rootEntity, leafRelationship));
        for (QuerySolution soln : pageResults) {
            result.add(soln.getResource("subject").getURI());
        }
        return result;
    }

    private ArrayList<QuerySolution> getSubNodes(String rootEntity, String transitiveRelationship) {
        ArrayList<QuerySolution> result = this.pager.pageQuery(YagoQueryUtils.factSubjectsQuery(rootEntity, transitiveRelationship));
        return result;
    }

    public static void main(String[] args) {
        SparqlTransitiveClosure st = new SparqlTransitiveClosure(YagoQueryUtils.YAGO_SPARQL_ENDPOINT);
        HashSet<String> res = st.getAllTransitiveLeavesOf(YagoQueryUtils.WORDNET_COMPANY_URI, "rdfs:subClassOf", "rdf:type");
        System.out.println(res.size());
    }
}

