/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.namedentity;

import java.util.ArrayList;

public class Rationaliser {
    ArrayList<Section> sections;

    public ArrayList<String> getCombinations(String word) {
        ArrayList<String> result = new ArrayList<String>();
        char[] characters = word.toCharArray();
        this.sections = new ArrayList();
        Character last = null;
        int lastCount = 0;
        StringBuffer unclassed = new StringBuffer();
        for (int i = 0; i < characters.length; ++i) {
            char current = characters[i];
            if (last == null) {
                last = Character.valueOf(current);
                lastCount = (char)(lastCount + 1);
                continue;
            }
            if (last.equals(Character.valueOf(current))) {
                if (lastCount > 1) continue;
                if (unclassed.length() > 0) {
                    StringBuffer pass = unclassed;
                    unclassed = new StringBuffer();
                    this.sections.add(new ValidSection(pass));
                }
                lastCount = (char)(lastCount + 1);
                RepeatSection n = new RepeatSection(new StringBuffer(last.toString()));
                this.sections.add(n);
                continue;
            }
            if (lastCount == 1) {
                unclassed.append(last);
            }
            last = Character.valueOf(current);
            lastCount = 1;
        }
        if (lastCount == 1) {
            unclassed.append(last);
        }
        if (unclassed.length() > 0) {
            this.sections.add(new ValidSection(unclassed));
        }
        for (StringBuffer sb : this.getSubCombinations(0)) {
            result.add(sb.toString());
        }
        return result;
    }

    private ArrayList<StringBuffer> getSubCombinations(int position) {
        if (position == this.sections.size() - 1) {
            return this.sections.get(position).getCombinations();
        }
        ArrayList<StringBuffer> result = new ArrayList<StringBuffer>();
        for (StringBuffer stringBuffer : this.sections.get(position).getCombinations()) {
            for (StringBuffer stringBuffer2 : this.getSubCombinations(position + 1)) {
                result.add(new StringBuffer(new StringBuffer(stringBuffer).append(stringBuffer2)));
            }
        }
        return result;
    }

    public static void main(String[] args) {
        Rationaliser rc = new Rationaliser();
        for (String s : rc.getCombinations("BBBlaaaaddddiblah")) {
            System.out.println(s);
        }
    }

    private class RepeatSection
    extends Section {
        public RepeatSection(StringBuffer value) {
            super(value);
        }

        @Override
        public ArrayList<StringBuffer> getCombinations() {
            ArrayList<StringBuffer> res = new ArrayList<StringBuffer>();
            res.add(new StringBuffer(this.value));
            StringBuffer two = new StringBuffer(this.value);
            two.append(this.value.toString().toCharArray()[0]);
            res.add(two);
            return res;
        }
    }

    private class ValidSection
    extends Section {
        public ValidSection(StringBuffer value) {
            super(value);
        }

        @Override
        public ArrayList<StringBuffer> getCombinations() {
            ArrayList<StringBuffer> res = new ArrayList<StringBuffer>();
            res.add(new StringBuffer(this.value));
            return res;
        }
    }

    private abstract class Section {
        public StringBuffer value;

        public Section(StringBuffer value) {
            this.value = value;
        }

        public abstract ArrayList<StringBuffer> getCombinations();
    }
}

