/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.namedentity;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

public class QuickSearcher {
    IndexSearcher searcher;
    Analyzer analyser;

    public QuickSearcher(Directory index, Analyzer analyser) {
        try {
            DirectoryReader reader = DirectoryReader.open((Directory)index);
            this.searcher = new IndexSearcher((IndexReader)reader);
        }
        catch (CorruptIndexException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.analyser = analyser;
    }

    public HashMap<String[], Float> search(String searchfieldName, String[] returnFieldName, String queryStr, int limit) throws ParseException, IOException {
        if (queryStr == null || queryStr.length() == 0) {
            return new HashMap<String[], Float>();
        }
        String clean = QueryParser.escape((String)queryStr);
        Query q = new QueryParser(Version.LUCENE_40, searchfieldName, this.analyser).parse(clean);
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)limit, (boolean)true);
        this.searcher.search(q, (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        HashMap<String[], Float> results = new HashMap<String[], Float>();
        for (int i = 0; i < hits.length; ++i) {
            int docId = hits[i].doc;
            Document d = this.searcher.doc(docId);
            String[] rvalues = new String[returnFieldName.length];
            for (int j = 0; j < rvalues.length; ++j) {
                rvalues[j] = d.get(returnFieldName[j]);
            }
            results.put(rvalues, Float.valueOf(hits[i].score));
        }
        return results;
    }

    public HashMap<String[], Float> searchFiltered(String searchfieldName, String[] returnFieldName, String queryStr, String filterFieldName, List<String> filterQueries) {
        if (queryStr == null || queryStr.length() == 0) {
            return new HashMap<String[], Float>();
        }
        HashMap<String[], Float> results = new HashMap<String[], Float>();
        TermsFilter qf = new TermsFilter();
        for (String filterValue : filterQueries) {
            qf.addTerm(new Term(filterFieldName, filterValue));
        }
        String clean = QueryParser.escape((String)queryStr);
        Query q = null;
        try {
            q = new QueryParser(Version.LUCENE_40, searchfieldName, this.analyser).parse(clean);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        try {
            ScoreDoc[] hits = this.searcher.search((Query)q, (Filter)qf, (int)filterQueries.size()).scoreDocs;
            for (int i = 0; i < hits.length; ++i) {
                int docId = hits[i].doc;
                Document d = this.searcher.doc(docId);
                String[] rvalues = new String[returnFieldName.length];
                for (int j = 0; j < rvalues.length; ++j) {
                    rvalues[j] = d.get(returnFieldName[j]);
                }
                results.put(rvalues, Float.valueOf(hits[i].score));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return results;
    }
}

