/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.web.scraping.images;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openimaj.util.api.auth.DefaultTokenFactory;
import org.openimaj.util.auth.web.TumblrAPIToken;
import org.openimaj.web.scraping.SiteSpecificConsumer;

public class TmblrPhotoConsumer
implements SiteSpecificConsumer {
    private transient Gson gson = new Gson();
    private TumblrAPIToken token;
    String tumblrAPICall = "http://api.tumblr.com/v2/blog/derekg.org/posts?id=%s&api_key=%s";

    public TmblrPhotoConsumer() {
        this((TumblrAPIToken)DefaultTokenFactory.get(TumblrAPIToken.class));
    }

    public TmblrPhotoConsumer(TumblrAPIToken token) {
        this.token = token;
    }

    @Override
    public boolean canConsume(URL url) {
        return (url.getHost().equals("tmblr.co") || url.getHost().endsWith("tumblr.com")) && !url.getHost().contains("media");
    }

    @Override
    public List<URL> consume(URL url) {
        try {
            ArrayList<URL> images = new ArrayList<URL>();
            String postID = this.getPostID(url);
            if (postID == null) {
                return images;
            }
            String tmblrRequest = String.format(this.tumblrAPICall, postID, this.token.apikey);
            Map res = (Map)this.gson.fromJson((Reader)new InputStreamReader(new URL(tmblrRequest).openConnection().getInputStream()), Map.class);
            Map response = (Map)res.get("response");
            Map posts = (Map)((List)response.get("posts")).get(0);
            List photos = (List)posts.get("photos");
            if (photos == null) {
                return null;
            }
            for (Map photo : photos) {
                String photoURLStr = (String)((Map)photo.get("original_size")).get("url");
                URL photoURL = new URL(photoURLStr);
                images.add(photoURL);
            }
            return images;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private String getPostID(URL url) throws IOException {
        String host = url.getHost();
        URL loc = url;
        if (host.equals("tmblr.co") || host.equals("tumblr.com") || host.equals("www.tumblr.com")) {
            URL forwardURL = null;
            if (url.getHost().equals("tmblr.co")) {
                String tumblrCode = url.getPath();
                forwardURL = new URL("http://www.tumblr.com" + tumblrCode);
            } else {
                forwardURL = url;
            }
            HttpURLConnection con = (HttpURLConnection)forwardURL.openConnection();
            con.setInstanceFollowRedirects(false);
            String locStr = con.getHeaderField("Location");
            loc = new URL(locStr);
            con.disconnect();
        }
        String[] parts = loc.getPath().split("[/]");
        String postID = null;
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].equals("post")) continue;
            postID = parts[i + 1];
            break;
        }
        return postID;
    }
}

