/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.statistics.distribution;

import org.openimaj.feature.MultidimensionalDoubleFV;

public class MultidimensionalHistogram
extends MultidimensionalDoubleFV {
    private static final long serialVersionUID = 1L;

    public MultidimensionalHistogram(int ... nbins) {
        super(nbins);
    }

    public void normalise() {
        int i;
        double sum = 0.0;
        for (i = 0; i < ((double[])this.values).length; ++i) {
            sum += ((double[])this.values)[i];
        }
        i = 0;
        while (i < ((double[])this.values).length) {
            double[] dArray = (double[])this.values;
            int n = i++;
            dArray[n] = dArray[n] / sum;
        }
    }

    public double max() {
        double max = Double.MIN_VALUE;
        for (int i = 0; i < ((double[])this.values).length; ++i) {
            max = Math.max(((double[])this.values)[i], max);
        }
        return max;
    }

    @Override
    public MultidimensionalHistogram clone() {
        return (MultidimensionalHistogram)super.clone();
    }
}

