/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.normalisation;

import org.openimaj.feature.FloatFV;
import org.openimaj.feature.normalisation.Normaliser;

public class HellingerNormaliser
implements Normaliser<FloatFV> {
    protected int offset;

    public HellingerNormaliser() {
        this.offset = 0;
    }

    public HellingerNormaliser(int offset) {
        this.offset = offset;
    }

    @Override
    public void normalise(FloatFV feature) {
        HellingerNormaliser.normalise((float[])feature.values, this.offset);
    }

    public static void normalise(float[] values, int offset) {
        int i;
        double sum = 0.0;
        for (i = 0; i < values.length; ++i) {
            int n = i;
            values[n] = values[n] + (float)offset;
            sum += (double)values[i];
        }
        for (i = 0; i < values.length; ++i) {
            values[i] = (float)Math.sqrt((double)values[i] / sum);
        }
    }
}

