/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Scanner;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVector;
import org.openimaj.util.array.SparseBinSearchByteArray;
import org.openimaj.util.array.SparseByteArray;
import org.openimaj.util.concatenate.Concatenatable;

public class SparseByteFV
implements FeatureVector,
Concatenatable<SparseByteFV, SparseByteFV> {
    private static final long serialVersionUID = 1L;
    public SparseByteArray values;

    protected SparseByteFV() {
    }

    public SparseByteFV(int nbins) {
        this.values = new SparseBinSearchByteArray(nbins);
    }

    public SparseByteFV(SparseByteArray values) {
        this.values = values;
    }

    public SparseByteFV(byte[] values) {
        this.values = new SparseBinSearchByteArray(values);
    }

    public void readASCII(Scanner in) throws IOException {
        this.values = new SparseBinSearchByteArray(0);
        this.values.readASCII(in);
    }

    public String asciiHeader() {
        return "SByteFV";
    }

    public void readBinary(DataInput in) throws IOException {
        this.values = new SparseBinSearchByteArray(0);
        this.values.readBinary(in);
    }

    public byte[] binaryHeader() {
        return "SByteFV".getBytes();
    }

    public void writeASCII(PrintWriter out) throws IOException {
        this.values.writeASCII(out);
    }

    public void writeBinary(DataOutput out) throws IOException {
        this.values.writeBinary(out);
    }

    public SparseByteArray getVector() {
        return this.values;
    }

    @Override
    public int length() {
        return this.values.length;
    }

    @Override
    public DoubleFV normaliseFV(double[] min, double[] max) {
        double[] dvals = this.asDoubleVector();
        for (int i = 0; i < dvals.length; ++i) {
            int n = i;
            dvals[n] = dvals[n] - min[i];
            int n2 = i;
            dvals[n2] = dvals[n2] / (max[i] - min[i]);
            if (dvals[i] < 0.0) {
                dvals[i] = 0.0;
            }
            if (!(dvals[i] > 1.0)) continue;
            dvals[i] = 1.0;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV(double min, double max) {
        double[] dvals = this.asDoubleVector();
        for (int i = 0; i < dvals.length; ++i) {
            int n = i;
            dvals[n] = dvals[n] - min;
            int n2 = i;
            dvals[n2] = dvals[n2] / (max - min);
            if (dvals[i] < 0.0) {
                dvals[i] = 0.0;
            }
            if (!(dvals[i] > 1.0)) continue;
            dvals[i] = 1.0;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV() {
        int i;
        double[] dvals = this.asDoubleVector();
        double sum = 0.0;
        for (i = 0; i < dvals.length; ++i) {
            sum += dvals[i];
        }
        i = 0;
        while (i < dvals.length) {
            int n = i++;
            dvals[n] = dvals[n] / sum;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV(double p) {
        return this.asDoubleFV().normaliseFV(p);
    }

    @Override
    public DoubleFV asDoubleFV() {
        return new DoubleFV(this.asDoubleVector());
    }

    @Override
    public double[] asDoubleVector() {
        double[] d = new double[this.values.length];
        for (SparseByteArray.Entry e : this.values.entries()) {
            d[e.index] = e.value;
        }
        return d;
    }

    public SparseByteFV concatenate(SparseByteFV ... ins) {
        SparseByteArray[] insValues = new SparseByteArray[ins.length];
        for (int i = 0; i < ins.length; ++i) {
            insValues[i] = ins[i].values;
        }
        SparseByteArray vals = this.values.concatenate(insValues);
        return new SparseByteFV(vals);
    }

    public SparseByteFV concatenate(List<SparseByteFV> ins) {
        SparseByteArray[] insValues = new SparseByteArray[ins.size()];
        for (int i = 0; i < ins.size(); ++i) {
            insValues[i] = ins.get((int)i).values;
        }
        SparseByteArray vals = this.values.concatenate(insValues);
        return new SparseByteFV(vals);
    }

    @Override
    public double getAsDouble(int i) {
        return this.values.get(i);
    }

    @Override
    public void setFromDouble(int i, double v) {
        this.values.set(i, (byte)v);
    }

    @Override
    public SparseByteFV newInstance() {
        return new SparseByteFV(this.length());
    }
}

