/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.openimaj.feature.ArrayFeatureVector;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.LongFVComparison;
import org.openimaj.util.concatenate.Concatenatable;

public class LongFV
extends ArrayFeatureVector<long[]>
implements Concatenatable<LongFV, LongFV>,
Cloneable {
    private static final long serialVersionUID = 1L;

    public LongFV() {
    }

    public LongFV(int nbins) {
        this.values = new long[nbins];
    }

    public LongFV(long[] values) {
        this.values = values;
    }

    public long get(int x) {
        return ((long[])this.values)[x];
    }

    void set(long value, int x) {
        ((long[])this.values)[x] = value;
    }

    @Override
    public DoubleFV normaliseFV(double[] min, double[] max) {
        double[] dvals = this.asDoubleVector();
        for (int i = 0; i < dvals.length; ++i) {
            int n = i;
            dvals[n] = dvals[n] - min[i];
            int n2 = i;
            dvals[n2] = dvals[n2] / (max[i] - min[i]);
            if (dvals[i] < 0.0) {
                dvals[i] = 0.0;
            }
            if (!(dvals[i] > 1.0)) continue;
            dvals[i] = 1.0;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV(double min, double max) {
        double[] dvals = this.asDoubleVector();
        for (int i = 0; i < dvals.length; ++i) {
            int n = i;
            dvals[n] = dvals[n] - min;
            int n2 = i;
            dvals[n2] = dvals[n2] / (max - min);
            if (dvals[i] < 0.0) {
                dvals[i] = 0.0;
            }
            if (!(dvals[i] > 1.0)) continue;
            dvals[i] = 1.0;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV() {
        int i;
        double[] dvals = this.asDoubleVector();
        double sum = 0.0;
        for (i = 0; i < dvals.length; ++i) {
            sum += dvals[i];
        }
        i = 0;
        while (i < dvals.length) {
            int n = i++;
            dvals[n] = dvals[n] / sum;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV(double p) {
        int i;
        double[] dvals = this.asDoubleVector();
        double pnorm = 0.0;
        for (i = 0; i < dvals.length; ++i) {
            pnorm += Math.pow(Math.abs(dvals[i]), p);
        }
        pnorm = Math.pow(pnorm, 1.0 / p);
        i = 0;
        while (i < dvals.length) {
            int n = i++;
            dvals[n] = dvals[n] / pnorm;
        }
        return new DoubleFV(dvals);
    }

    public LongFV clone() {
        try {
            LongFV model = (LongFV)super.clone();
            model.values = ((long[])this.values).clone();
            return model;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        String ret = this.getClass().getName() + Arrays.toString((long[])this.values);
        return ret;
    }

    @Override
    public DoubleFV asDoubleFV() {
        return new DoubleFV(this.asDoubleVector());
    }

    @Override
    public double[] asDoubleVector() {
        double[] d = new double[((long[])this.values).length];
        for (int i = 0; i < ((long[])this.values).length; ++i) {
            d[i] = ((long[])this.values)[i];
        }
        return d;
    }

    public double compare(LongFV h, LongFVComparison method) {
        return method.compare(this, h);
    }

    @Override
    public int length() {
        return ((long[])this.values).length;
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(((long[])this.values).length);
        for (int i = 0; i < ((long[])this.values).length; ++i) {
            out.writeLong(((long[])this.values)[i]);
        }
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.println(((long[])this.values).length);
        for (int i = 0; i < ((long[])this.values).length; ++i) {
            out.print(((long[])this.values)[i] + " ");
        }
        out.println();
    }

    public void readBinary(DataInput in) throws IOException {
        int nbins = in.readInt();
        this.values = new long[nbins];
        for (int i = 0; i < nbins; ++i) {
            ((long[])this.values)[i] = in.readLong();
        }
    }

    public void readASCII(Scanner in) throws IOException {
        int nbins = Integer.parseInt(in.nextLine());
        this.values = new long[nbins];
        String[] line = in.nextLine().trim().split(" ");
        for (int i = 0; i < nbins; ++i) {
            ((long[])this.values)[i] = Long.parseLong(line[i]);
        }
    }

    public byte[] binaryHeader() {
        return (this.getClass().getName().substring(0, 2) + "FV").getBytes();
    }

    public String asciiHeader() {
        return this.getClass().getName() + " ";
    }

    public LongFV concatenate(LongFV ... ins) {
        int l = ((long[])this.values).length;
        for (int i = 0; i < ins.length; ++i) {
            l += ((long[])ins[i].values).length;
        }
        long[] data = new long[l];
        System.arraycopy(this.values, 0, data, 0, ((long[])this.values).length);
        int offset = ((long[])this.values).length;
        for (int i = 0; i < ins.length; ++i) {
            System.arraycopy(ins[i].values, 0, data, offset, ((long[])ins[i].values).length);
            offset += ((long[])ins[i].values).length;
        }
        return new LongFV(data);
    }

    public LongFV concatenate(List<LongFV> ins) {
        int l = ((long[])this.values).length;
        for (int i = 0; i < ins.size(); ++i) {
            l += ((long[])ins.get((int)i).values).length;
        }
        long[] data = new long[l];
        System.arraycopy(this.values, 0, data, 0, ((long[])this.values).length);
        int offset = ((long[])this.values).length;
        for (int i = 0; i < ins.size(); ++i) {
            System.arraycopy(ins.get((int)i).values, 0, data, offset, ((long[])ins.get((int)i).values).length);
            offset += ((long[])ins.get((int)i).values).length;
        }
        return new LongFV(data);
    }

    public int hashCode() {
        return Arrays.hashCode((long[])this.values);
    }

    public boolean equals(Object obj) {
        return Arrays.equals((long[])this.values, (long[])((LongFV)obj).values);
    }

    public LongFV subvector(int beginIndex) {
        return new LongFV(Arrays.copyOfRange((long[])this.values, beginIndex, ((long[])this.values).length));
    }

    public LongFV subvector(int beginIndex, int endIndex) {
        return new LongFV(Arrays.copyOfRange((long[])this.values, beginIndex, endIndex));
    }

    @Override
    public double getAsDouble(int i) {
        return ((long[])this.values)[i];
    }

    @Override
    public void setFromDouble(int i, double v) {
        ((long[])this.values)[i] = (long)v;
    }

    @Override
    public LongFV newInstance() {
        return new LongFV(this.length());
    }
}

