/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.blockcache;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.store.blockcache.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferStore {
    public static Logger LOG = LoggerFactory.getLogger(BufferStore.class);
    private static BlockingQueue<byte[]> _1024 = BufferStore.setupBuffers(1024, 1);
    private static BlockingQueue<byte[]> _8192 = BufferStore.setupBuffers(8192, 1);
    public static AtomicLong shardBuffercacheLost = new AtomicLong();
    public static AtomicLong shardBuffercacheAllocate1024 = new AtomicLong();
    public static AtomicLong shardBuffercacheAllocate8192 = new AtomicLong();
    public static AtomicLong shardBuffercacheAllocateOther = new AtomicLong();

    public static void init(int _1024Size, int _8192Size, Metrics metrics) {
        LOG.info("Initializing the 1024 buffers with [{}] buffers.", (Object)_1024Size);
        _1024 = BufferStore.setupBuffers(1024, _1024Size);
        LOG.info("Initializing the 8192 buffers with [{}] buffers.", (Object)_8192Size);
        _8192 = BufferStore.setupBuffers(8192, _8192Size);
        shardBuffercacheLost = metrics.shardBuffercacheLost;
        shardBuffercacheAllocate1024 = metrics.shardBuffercacheAllocate1024;
        shardBuffercacheAllocate8192 = metrics.shardBuffercacheAllocate8192;
        shardBuffercacheAllocateOther = metrics.shardBuffercacheAllocateOther;
    }

    private static BlockingQueue<byte[]> setupBuffers(int bufferSize, int count) {
        ArrayBlockingQueue<byte[]> queue = new ArrayBlockingQueue<byte[]>(count);
        for (int i = 0; i < count; ++i) {
            queue.add(new byte[bufferSize]);
        }
        return queue;
    }

    public static byte[] takeBuffer(int bufferSize) {
        switch (bufferSize) {
            case 1024: {
                return BufferStore.newBuffer1024((byte[])_1024.poll());
            }
            case 8192: {
                return BufferStore.newBuffer8192((byte[])_8192.poll());
            }
        }
        return BufferStore.newBuffer(bufferSize);
    }

    public static void putBuffer(byte[] buffer) {
        if (buffer == null) {
            return;
        }
        int bufferSize = buffer.length;
        switch (bufferSize) {
            case 1024: {
                BufferStore.checkReturn(_1024.offer(buffer));
                return;
            }
            case 8192: {
                BufferStore.checkReturn(_8192.offer(buffer));
                return;
            }
        }
    }

    private static void checkReturn(boolean offer) {
        if (!offer) {
            shardBuffercacheLost.incrementAndGet();
        }
    }

    private static byte[] newBuffer1024(byte[] buf) {
        if (buf != null) {
            return buf;
        }
        shardBuffercacheAllocate1024.incrementAndGet();
        return new byte[1024];
    }

    private static byte[] newBuffer8192(byte[] buf) {
        if (buf != null) {
            return buf;
        }
        shardBuffercacheAllocate8192.incrementAndGet();
        return new byte[8192];
    }

    private static byte[] newBuffer(int size) {
        shardBuffercacheAllocateOther.incrementAndGet();
        return new byte[size];
    }
}

