/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.streams.formats;

import eu.larkc.csparql.cep.api.CepQuery;
import eu.larkc.csparql.core.Configuration;
import eu.larkc.csparql.parser.StreamInfo;
import eu.larkc.csparql.parser.TreeBox;
import eu.larkc.csparql.sparql.api.SparqlQuery;
import eu.larkc.csparql.streams.formats.CSparqlQuery;
import java.util.Collection;
import java.util.UUID;

public class CSparqlQueryImpl
implements CSparqlQuery {
    private String id = this.generateID();
    private String command = null;
    private CepQuery cepQuery = null;
    private SparqlQuery sparqlQuery = null;
    private TreeBox treeBox = null;

    public CSparqlQueryImpl(String cepQuery, String sparqlQuery, String cSparqlQuery) {
        this.command = cSparqlQuery;
        this.sparqlQuery = Configuration.getCurrentConfiguration().createSparqlQuery(sparqlQuery);
        this.cepQuery = Configuration.getCurrentConfiguration().createCepQuery(cepQuery);
    }

    private String generateID() {
        return UUID.randomUUID().toString();
    }

    @Override
    public CepQuery getCepQuery() {
        return this.cepQuery;
    }

    @Override
    public String getQueryCommand() {
        return this.command;
    }

    @Override
    public SparqlQuery getSparqlQuery() {
        return this.sparqlQuery;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public TreeBox getTreeBox() {
        return this.treeBox;
    }

    @Override
    public void setTreeBox(TreeBox tb) {
        this.treeBox = tb;
    }

    @Override
    public Collection<StreamInfo> getStreams() {
        return this.treeBox.getStreams();
    }
}

