/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.parser;

import eu.larkc.csparql.parser.PostProcessingException;
import eu.larkc.csparql.parser.TreeBox;
import eu.larkc.csparql.parser.TreeCheckerInterface;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrefixChecker
implements TreeCheckerInterface {
    @Override
    public void treeCheck(TreeBox t) throws PostProcessingException {
        List<TreeBox> prefixList = t.getNodesByText("prefixDecl");
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        for (TreeBox tbx : prefixList) {
            if (prefixMap.containsKey(tbx.getChild(1).getText())) {
                throw new PostProcessingException("Prefix " + tbx.getChild(1).getText() + "already declared twice in the query");
            }
            prefixMap.put(tbx.getChild(1).getText(), tbx.getChild(2).getText());
        }
        List<TreeBox> prefixedNames = t.getNodesByText("prefixedName");
        for (TreeBox tbx : prefixedNames) {
            Pattern pattern = Pattern.compile(".*:");
            Matcher matcher = pattern.matcher(tbx.getChild(0).getText());
            if (!matcher.find() || prefixMap.containsKey(matcher.group())) continue;
            throw new PostProcessingException("Prefix  used without declaration");
        }
    }
}

