/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.parser;

import eu.larkc.csparql.engine.CsparqlEngine;
import eu.larkc.csparql.parser.DefaultEplProducer;
import eu.larkc.csparql.parser.LogicalWindow;
import eu.larkc.csparql.parser.PhysicalWindow;
import eu.larkc.csparql.parser.StreamInfo;
import eu.larkc.csparql.parser.TimeUtils;
import eu.larkc.csparql.parser.TreeBox;
import eu.larkc.csparql.parser.Window;
import eu.larkc.csparql.streams.formats.TranslationException;
import java.util.HashSet;
import java.util.Set;

public class EplProducer1_0
extends DefaultEplProducer {
    public EplProducer1_0(CsparqlEngine engine) {
        super(engine);
    }

    @Override
    public Set<String> produceEpl(TreeBox t) throws TranslationException {
        if (t.isCSparql()) {
            TreeBox dupTree = TreeBox.dupFullTreeDecorated(t);
            Set<StreamInfo> streams = dupTree.getStreams();
            HashSet<String> result = new HashSet<String>();
            for (StreamInfo si : streams) {
                StringBuffer s = new StringBuffer("select * from ");
                String iri = si.getIri();
                if (iri == null) {
                    TranslationException e = new TranslationException("Stream IRI " + iri + " not found");
                    e.setIri(iri);
                    throw e;
                }
                s.append(this.convertStreamIri(iri));
                s.append('.');
                Window w = si.getWindow();
                if (si.hasPhisicalWindow()) {
                    PhysicalWindow ph = (PhysicalWindow)w;
                    s.append("win:length_batch(");
                    s.append(w.getWindowRange());
                    s.append(")");
                    s.append(" output snapshot every ");
                    s.append(ph.windowRange);
                    s.append(" events");
                } else {
                    LogicalWindow l = (LogicalWindow)w;
                    String range = TimeUtils.getSeconds(l.getWindowRange(), l.getRangeTimeUnit());
                    if (l.isTumbling()) {
                        s.append("win:time_batch(");
                        s.append(range);
                        s.append(")");
                    } else {
                        s.append("win:time(");
                        s.append(range);
                        s.append(")");
                        s.append(" output snapshot every ");
                        String step = TimeUtils.getSeconds(l.getStep(), l.getStepTimeUnit());
                        s.append(step);
                    }
                }
                result.add(s.toString());
            }
            return result;
        }
        return null;
    }
}

