/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.core;

import eu.larkc.csparql.cep.api.CepEngine;
import eu.larkc.csparql.cep.api.CepQuery;
import eu.larkc.csparql.engine.CsparqlEngine;
import eu.larkc.csparql.engine.Reasoner;
import eu.larkc.csparql.parser.Translator;
import eu.larkc.csparql.sparql.api.SparqlEngine;
import eu.larkc.csparql.sparql.api.SparqlQuery;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class Configuration {
    private static Configuration instance;
    private final String cepEngineName = "eu.larkc.csparql.cep.esper.EsperEngine";
    private final String reasonerName = "eu.larkc.csparql.engine.TransparentReasoner";
    private final String sparqlEngineName = "eu.larkc.csparql.sparql.jena.JenaEngine";
    private final String cepQueryName = "eu.larkc.csparql.cep.esper.EsperQuery";
    private final String sparqlQueryName = "eu.larkc.csparql.sparql.sesame.SesameQuery";
    private final String translatorName = "eu.larkc.csparql.parser.CSparqlTranslator";

    public static Configuration getCurrentConfiguration() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    public Reasoner createReasoner() {
        Class<?> c = null;
        try {
            c = Class.forName("eu.larkc.csparql.engine.TransparentReasoner");
            return (Reasoner)c.newInstance();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Translator createTranslator(CsparqlEngine engine) {
        Class<?> c = null;
        try {
            c = Class.forName("eu.larkc.csparql.parser.CSparqlTranslator");
            Translator t = (Translator)c.newInstance();
            t.setEngine(engine);
            return t;
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public CepQuery createCepQuery(String command) {
        Class<?> c = null;
        CepQuery e = null;
        try {
            c = Class.forName("eu.larkc.csparql.cep.esper.EsperQuery");
            Constructor<?>[] ctors = c.getConstructors();
            e = (CepQuery)ctors[0].newInstance(command);
            return e;
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public SparqlQuery createSparqlQuery(String command) {
        Class<?> c = null;
        SparqlQuery e = null;
        try {
            Constructor<?>[] ctors;
            c = Class.forName("eu.larkc.csparql.sparql.sesame.SesameQuery");
            Constructor<?>[] constructorArray = ctors = c.getConstructors();
            int n = ctors.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> cc = constructorArray[n2];
                if (cc.getParameterTypes().length == 1) {
                    e = (SparqlQuery)cc.newInstance(command);
                    return e;
                }
                ++n2;
            }
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public CepEngine createCepEngine() {
        Class<?> c = null;
        CepEngine e = null;
        try {
            c = Class.forName("eu.larkc.csparql.cep.esper.EsperEngine");
            e = (CepEngine)c.newInstance();
            return e;
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public SparqlEngine createSparqlEngine() {
        Class<?> c = null;
        SparqlEngine e = null;
        try {
            c = Class.forName("eu.larkc.csparql.sparql.jena.JenaEngine");
            e = (SparqlEngine)c.newInstance();
            return e;
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

