/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.semanticdesktop.aperture.util.StringUtil;

public class UrlUtil {
    public static URL normalizeURL(URL url) {
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        String path = url.getPath();
        String query = url.getQuery();
        protocol = protocol.toLowerCase();
        host = host.toLowerCase();
        if (port == url.getDefaultPort()) {
            port = -1;
        }
        String file = UrlUtil.normalizePath(path);
        if (query != null) {
            query = UrlUtil.normalizeQuery(query);
            file = file + "?" + query;
        }
        try {
            return new URL(protocol, host, port, file);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String normalizePath(String path) {
        String result = path;
        result = StringUtil.replace("//", "/", result);
        result = StringUtil.replace("/./", "/", result);
        result = result.replaceAll("/[^/]+/\\.\\./", "/");
        return result;
    }

    public static String normalizeQuery(String query) {
        TreeSet<String> sortedSet = new TreeSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(query, "&");
        while (tokenizer.hasMoreTokens()) {
            sortedSet.add(tokenizer.nextToken());
        }
        StringBuilder result = new StringBuilder(query.length());
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            result.append(iterator.next());
            if (!iterator.hasNext()) continue;
            result.append('&');
        }
        return result.toString();
    }
}

