/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.io.File;
import java.io.IOException;

public abstract class OSUtils {
    private static final String[] bundleextension = new String[]{".app", ".bundle", ".framework", ".kext", ".mpkg", "mdimporter", ".nib", ".pbproj", ".pkg", ".plugin", ".prefPane", ".rtfd", ".saver", ".slideSaver", ".wdgt", ".webarchive", ".xcode", ".xcodeproj", ".key", ".pages"};

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }

    public static boolean isMacOSXBundle(File f) {
        if (!OSUtils.isMac()) {
            return false;
        }
        try {
            return OSUtils.isBundle(f);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isBundle(File f) throws IOException {
        if (f.isDirectory()) {
            String filename = f.getName();
            for (String e : bundleextension) {
                if (!filename.endsWith(e)) continue;
                return true;
            }
        }
        return false;
    }
}

