/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.zip.Adler32;

public class IOUtil {
    public static char[] readChars(Reader r) throws IOException {
        return IOUtil.readFully(r).toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            String string = IOUtil.readString(in);
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(URL url) throws IOException {
        String result = null;
        Reader reader = IOUtil.urlToReader(url);
        try {
            result = IOUtil.readString(reader);
        }
        finally {
            reader.close();
        }
        return result;
    }

    public static String readString(InputStream in) throws IOException {
        return IOUtil.readString(new InputStreamReader(in));
    }

    public static String readString(InputStream in, Charset charset) throws IOException {
        return IOUtil.readString(new InputStreamReader(in, charset));
    }

    public static String readString(Reader r) throws IOException {
        return IOUtil.readFully(r).toString();
    }

    public static String readString(Reader r, int maxChars) throws IOException {
        char[] charBuf = new char[maxChars];
        int charsRead = IOUtil.fillCharArray(r, charBuf);
        return new String(charBuf, 0, charsRead);
    }

    public static int fillCharArray(Reader r, char[] charArray) throws IOException {
        int result = 0;
        int charsRead = r.read(charArray);
        while (charsRead >= 0 && (result += charsRead) != charArray.length) {
            charsRead = r.read(charArray, result, charArray.length - result);
        }
        return result;
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        IOUtil.writeStream(in, out);
        return out.toByteArray();
    }

    public static byte[] readBytes(InputStream in, int maxBytes) throws IOException {
        byte[] result = new byte[maxBytes];
        int bytesRead = IOUtil.fillByteArray(in, result);
        if (bytesRead < maxBytes) {
            byte[] tmp = new byte[bytesRead];
            System.arraycopy(result, 0, tmp, 0, bytesRead);
            result = tmp;
        }
        return result;
    }

    public static String rollingHash(InputStream stream) throws IOException {
        int bytesRead;
        Adler32 adler = new Adler32();
        adler.reset();
        byte[] buffer = new byte[4096];
        while ((bytesRead = stream.read(buffer)) != -1) {
            adler.update(buffer, 0, bytesRead);
        }
        return String.valueOf(adler.getValue());
    }

    public static int fillByteArray(InputStream in, byte[] byteArray) throws IOException {
        int result = 0;
        int bytesRead = in.read(byteArray);
        while (bytesRead >= 0 && (result += bytesRead) != byteArray.length) {
            bytesRead = in.read(byteArray, result, byteArray.length - result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStream(InputStream in, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            IOUtil.writeStream(in, out);
        }
        finally {
            try {
                out.flush();
            }
            finally {
                out.close();
            }
        }
    }

    public static void writeStream(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[4096];
        int bytesRead = 0;
        while ((bytesRead = in.read(buf)) != -1) {
            out.write(buf, 0, bytesRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(String contents, File file) throws IOException {
        FileWriter out = new FileWriter(file);
        try {
            out.write(contents);
        }
        finally {
            out.close();
        }
    }

    public static void writeString(String contents, String filename) throws IOException {
        IOUtil.writeString(contents, new File(filename));
    }

    public static Reader urlToReader(URL url) throws IOException {
        URLConnection con = url.openConnection();
        return new InputStreamReader(con.getInputStream());
    }

    private static CharArrayWriter readFully(Reader r) throws IOException {
        char[] buf = new char[4096];
        int charsRead = 0;
        CharArrayWriter result = new CharArrayWriter();
        while ((charsRead = r.read(buf)) != -1) {
            result.write(buf, 0, charsRead);
        }
        return result;
    }
}

