/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.zip.GZIPInputStream;

public class HttpClientUtil {
    public static void formUrlEncode(String s, StringBuilder buffer) {
        HttpClientUtil.formUrlEncode(s, buffer, null);
    }

    public static String formUrlEncode(String s) {
        StringBuilder result = new StringBuilder(s.length() + 10);
        HttpClientUtil.formUrlEncode(s, result, null);
        return result.toString();
    }

    public static String formUrlEncode(String string, String charsToLeave) {
        StringBuilder result = new StringBuilder(string.length() + 10);
        HttpClientUtil.formUrlEncode(string, result, charsToLeave);
        return result.toString();
    }

    public static String formUrlDecode(String string) {
        int length = string.length();
        StringBuilder buffer = new StringBuilder(length + 10);
        int i = 0;
        while (i < length) {
            char c = string.charAt(i);
            if (c == '+') {
                buffer.append(' ');
                ++i;
                continue;
            }
            if (c == '%') {
                int start = i;
                String character = "";
                while ((i += 3) < length && string.charAt(i) == '%') {
                }
                try {
                    character = URLDecoder.decode(string.substring(start, i), "UTF-8");
                }
                catch (Exception e) {
                    // empty catch block
                }
                buffer.append(character);
                continue;
            }
            buffer.append(c);
            ++i;
        }
        return buffer.toString();
    }

    public static void setAcceptGZIPEncoding(URLConnection conn) {
        conn.setRequestProperty("Accept-Encoding", "gzip");
    }

    public static InputStream getInputStream(URLConnection conn) throws IOException {
        InputStream responseStream = conn.getInputStream();
        if ("gzip".equalsIgnoreCase(conn.getContentEncoding())) {
            responseStream = new GZIPInputStream(responseStream);
        }
        return responseStream;
    }

    private static void formUrlEncode(String s, StringBuilder buffer, String charsToLeave) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == ' ') {
                buffer.append('+');
                continue;
            }
            char cInt = c;
            if (cInt >= '0' && cInt <= '9' || cInt >= 'A' && cInt <= 'Z' || cInt >= 'a' && cInt <= 'z' || cInt == '-' || cInt == '_' || cInt == '.' || cInt == '~' || charsToLeave != null && charsToLeave.indexOf(c) != -1) {
                buffer.append(c);
                continue;
            }
            if (cInt == '*') {
                buffer.append("%2a");
                continue;
            }
            String stringVal = String.valueOf(c);
            String hexVal = null;
            try {
                hexVal = URLEncoder.encode(stringVal, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            buffer.append(hexVal);
        }
    }
}

