/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.validation.cross;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.openimaj.data.RandomData;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.experiment.dataset.util.DatasetAdaptors;
import org.openimaj.experiment.validation.DefaultValidationData;
import org.openimaj.experiment.validation.ValidationData;
import org.openimaj.experiment.validation.cross.CrossValidationIterable;
import org.openimaj.experiment.validation.cross.CrossValidator;
import org.openimaj.util.list.AcceptingListView;
import org.openimaj.util.list.SkippingListView;

public class KFold<INSTANCE>
implements CrossValidator<ListDataset<INSTANCE>> {
    private int k;

    public KFold(int k) {
        this.k = k;
    }

    @Override
    public CrossValidationIterable<ListDataset<INSTANCE>> createIterable(ListDataset<INSTANCE> data) {
        return new KFoldIterable(data, this.k);
    }

    public String toString() {
        return this.k + "-Fold Cross-Validation";
    }

    private class KFoldIterable
    implements CrossValidationIterable<ListDataset<INSTANCE>> {
        private List<INSTANCE> listView;
        private int[][] subsetIndices;

        public KFoldIterable(ListDataset<INSTANCE> dataset, int k) {
            if (k > dataset.size()) {
                throw new IllegalArgumentException("The number of folds must be less than the number of items in the dataset");
            }
            if (k <= 0) {
                throw new IllegalArgumentException("The number of folds must be at least one");
            }
            this.listView = DatasetAdaptors.asList(dataset);
            int[] allIndices = RandomData.getUniqueRandomInts((int)dataset.size(), (int)0, (int)dataset.size());
            this.subsetIndices = new int[k][];
            int splitSize = dataset.size() / k;
            for (int i = 0; i < k - 1; ++i) {
                this.subsetIndices[i] = Arrays.copyOfRange(allIndices, splitSize * i, splitSize * (i + 1));
            }
            this.subsetIndices[k - 1] = Arrays.copyOfRange(allIndices, splitSize * (k - 1), allIndices.length);
        }

        @Override
        public int numberIterations() {
            return this.subsetIndices.length;
        }

        @Override
        public Iterator<ValidationData<ListDataset<INSTANCE>>> iterator() {
            return new Iterator<ValidationData<ListDataset<INSTANCE>>>(){
                int validationSubset = 0;

                @Override
                public boolean hasNext() {
                    return this.validationSubset < KFoldIterable.this.subsetIndices.length;
                }

                @Override
                public ValidationData<ListDataset<INSTANCE>> next() {
                    ListBackedDataset training = new ListBackedDataset((List)new SkippingListView(KFoldIterable.this.listView, KFoldIterable.this.subsetIndices[this.validationSubset]));
                    ListBackedDataset validation = new ListBackedDataset((List)new AcceptingListView(KFoldIterable.this.listView, KFoldIterable.this.subsetIndices[this.validationSubset]));
                    ++this.validationSubset;
                    return new DefaultValidationData<ListBackedDataset>(training, validation);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

