/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.classification.analysers.roc;

import gov.sandia.cognition.statistics.method.ReceiverOperatingCharacteristic;
import gov.sandia.cognition.util.DefaultPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openimaj.experiment.evaluation.classification.ClassificationAnalyser;
import org.openimaj.experiment.evaluation.classification.ClassificationResult;
import org.openimaj.experiment.evaluation.classification.analysers.roc.ROCResult;

public class ROCAnalyser<OBJECT, CLASS>
implements ClassificationAnalyser<ROCResult<CLASS>, CLASS, OBJECT> {
    @Override
    public ROCResult<CLASS> analyse(Map<OBJECT, ClassificationResult<CLASS>> predicted, Map<OBJECT, Set<CLASS>> actual) {
        HashSet allClasses = new HashSet();
        for (OBJECT o : predicted.keySet()) {
            allClasses.addAll(actual.get(o));
        }
        HashMap output = new HashMap();
        for (Object clz : allClasses) {
            ArrayList<DefaultPair> data = new ArrayList<DefaultPair>();
            for (OBJECT o : predicted.keySet()) {
                if (predicted.get(o) != null) {
                    double score = predicted.get(o).getConfidence(clz);
                    boolean objIsClass = actual.get(o).contains(clz);
                    data.add(new DefaultPair((Object)objIsClass, (Object)score));
                    continue;
                }
                data.add(new DefaultPair((Object)false, (Object)1.0));
            }
            output.put(clz, ReceiverOperatingCharacteristic.createFromTargetEstimatePairs(data));
        }
        return new ROCResult(output);
    }
}

