/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.agreement;

import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FleissInterraterAgreement {
    public static <K, A> double calculate(List<Map<K, A>> data) {
        HashMap<Object, TObjectIntHashMap> table = new HashMap<Object, TObjectIntHashMap>();
        TObjectDoubleHashMap cats = new TObjectDoubleHashMap();
        int totalCount = 0;
        for (Map<K, A> map : data) {
            for (Object subject : map.keySet()) {
                A annotation = map.get(subject);
                if (annotation == null) continue;
                TObjectIntHashMap count = (TObjectIntHashMap)table.get(subject);
                if (count == null) {
                    count = new TObjectIntHashMap();
                    table.put(subject, count);
                }
                count.putIfAbsent(annotation, 0);
                count.increment(annotation);
                cats.putIfAbsent(annotation, 0.0);
                cats.increment(annotation);
                ++totalCount;
            }
        }
        TDoubleArrayList Pj = new TDoubleArrayList();
        for (Object x : cats.keySet()) {
            Pj.add(cats.get(x) / (double)totalCount * (cats.get(x) / (double)totalCount));
        }
        int n = data.size();
        TDoubleArrayList Pis = new TDoubleArrayList();
        for (Object subject : table.keySet()) {
            double Pi = 0.0;
            for (Object cat : ((TObjectIntHashMap)table.get(subject)).keySet()) {
                int nij = ((TObjectIntHashMap)table.get(subject)).get(cat);
                Pi += (double)(nij * (nij - 1));
            }
            Pis.add(Pi /= (double)(n * (n - 1)));
        }
        double Pbar = Pis.sum() / (double)Pis.size();
        double PeBar = Pj.sum();
        double kappa = (Pbar - PeBar) / (1.0 - PeBar);
        return kappa;
    }
}

