/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.validation.cross;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openimaj.data.RandomData;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.experiment.dataset.util.DatasetAdaptors;
import org.openimaj.experiment.validation.DefaultValidationData;
import org.openimaj.experiment.validation.ValidationData;
import org.openimaj.experiment.validation.cross.CrossValidationIterable;
import org.openimaj.experiment.validation.cross.CrossValidator;
import org.openimaj.util.list.AcceptingListView;
import org.openimaj.util.list.SkippingListView;

public class StratifiedGroupedKFold<KEY, INSTANCE>
implements CrossValidator<GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE>> {
    private int k;

    public StratifiedGroupedKFold(int k) {
        this.k = k;
    }

    @Override
    public CrossValidationIterable<GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE>> createIterable(GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE> data) {
        return new StratifiedGroupedKFoldIterable(data, this.k);
    }

    public String toString() {
        return "Stratified " + this.k + "-Fold Cross-Validation for grouped datasets";
    }

    private class StratifiedGroupedKFoldIterable
    implements CrossValidationIterable<GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE>> {
        private GroupedDataset<KEY, ? extends ListDataset<INSTANCE>, INSTANCE> dataset;
        private Map<KEY, int[][]> subsetIndices = new HashMap();
        private int numFolds;

        public StratifiedGroupedKFoldIterable(GroupedDataset<KEY, ? extends ListDataset<INSTANCE>, INSTANCE> dataset, int k) {
            if (k > dataset.numInstances()) {
                throw new IllegalArgumentException("The number of folds must be less than the number of items in the dataset");
            }
            if (k <= 0) {
                throw new IllegalArgumentException("The number of folds must be at least one");
            }
            this.dataset = dataset;
            Set keys = dataset.getGroups();
            int minGroupSize = Integer.MAX_VALUE;
            for (Object group : keys) {
                int instancesSize = ((ListDataset)dataset.getInstances(group)).size();
                if (instancesSize >= minGroupSize) continue;
                minGroupSize = instancesSize;
            }
            this.numFolds = k < minGroupSize ? k : minGroupSize;
            for (Object group : keys) {
                int keySize = ((ListDataset)dataset.getInstances(group)).size();
                int[] allKeyIndices = RandomData.getUniqueRandomInts((int)keySize, (int)0, (int)keySize);
                this.subsetIndices.put(group, new int[this.numFolds][]);
                int[][] si = this.subsetIndices.get(group);
                int splitSize = keySize / this.numFolds;
                for (int i = 0; i < this.numFolds - 1; ++i) {
                    si[i] = Arrays.copyOfRange(allKeyIndices, splitSize * i, splitSize * (i + 1));
                }
                si[this.numFolds - 1] = Arrays.copyOfRange(allKeyIndices, splitSize * (this.numFolds - 1), allKeyIndices.length);
            }
        }

        @Override
        public int numberIterations() {
            return this.numFolds;
        }

        @Override
        public Iterator<ValidationData<GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE>>> iterator() {
            return new Iterator<ValidationData<GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE>>>(){
                int validationSubset = 0;

                @Override
                public boolean hasNext() {
                    return this.validationSubset < StratifiedGroupedKFoldIterable.this.numFolds;
                }

                @Override
                public ValidationData<GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE>> next() {
                    HashMap train = new HashMap();
                    HashMap valid = new HashMap();
                    for (Object group : StratifiedGroupedKFoldIterable.this.subsetIndices.keySet()) {
                        int[][] si = (int[][])StratifiedGroupedKFoldIterable.this.subsetIndices.get(group);
                        List keyData = DatasetAdaptors.asList(StratifiedGroupedKFoldIterable.this.dataset.getInstances(group));
                        train.put(group, new ListBackedDataset((List)new SkippingListView(keyData, si[this.validationSubset])));
                        valid.put(group, new ListBackedDataset((List)new AcceptingListView(keyData, si[this.validationSubset])));
                    }
                    MapBackedDataset cvTrain = new MapBackedDataset(train);
                    MapBackedDataset cvValid = new MapBackedDataset(valid);
                    ++this.validationSubset;
                    return new DefaultValidationData<MapBackedDataset>(cvTrain, cvValid);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

