/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.validation;

import java.util.Map;
import org.openimaj.data.RandomData;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.experiment.validation.DefaultValidationData;
import org.openimaj.util.pair.IndependentPair;

public class GroupedRandomisedPercentageHoldOut<KEY, INSTANCE>
extends DefaultValidationData<GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE>> {
    public GroupedRandomisedPercentageHoldOut(double percentageTraining, GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE> dataset) {
        if (percentageTraining < 0.0 || percentageTraining > 1.0) {
            throw new IllegalArgumentException("percentage of training instances must be between 0 and 1");
        }
        int size = dataset.numInstances();
        int[] indices = RandomData.getUniqueRandomInts((int)size, (int)0, (int)size);
        int nTrain = (int)(percentageTraining * (double)size);
        this.training = new MapBackedDataset();
        Map trainMap = ((MapBackedDataset)this.training).getMap();
        for (int i = 0; i < nTrain; ++i) {
            IndependentPair<KEY, INSTANCE> p = this.select(indices[i], dataset);
            ListBackedDataset lmd = (ListBackedDataset)trainMap.get(p.firstObject());
            if (lmd == null) {
                lmd = new ListBackedDataset();
                trainMap.put(p.firstObject(), lmd);
            }
            lmd.add(p.getSecondObject());
        }
        this.validation = new MapBackedDataset();
        Map validMap = ((MapBackedDataset)this.validation).getMap();
        for (int i = nTrain; i < size; ++i) {
            IndependentPair<KEY, INSTANCE> p = this.select(indices[i], dataset);
            ListBackedDataset lmd = (ListBackedDataset)validMap.get(p.firstObject());
            if (lmd == null) {
                lmd = new ListBackedDataset();
                validMap.put(p.firstObject(), lmd);
            }
            lmd.add(p.getSecondObject());
        }
    }

    private IndependentPair<KEY, INSTANCE> select(int idx, GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE> dataset) {
        for (Object k : dataset.getGroups()) {
            ListDataset instances = (ListDataset)dataset.getInstances(k);
            int sz = instances.size();
            if (idx < sz) {
                return new IndependentPair(k, instances.getInstance(idx));
            }
            idx -= sz;
        }
        return null;
    }
}

