/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.retrieval.analysers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.lemurproject.ireval.RetrievalEvaluator;
import org.openimaj.data.identity.Identifiable;
import org.openimaj.experiment.evaluation.retrieval.RetrievalAnalyser;
import org.openimaj.experiment.evaluation.retrieval.analysers.IREvalAnalyser;
import org.openimaj.experiment.evaluation.retrieval.analysers.TRECResult;

public class TRECEvalAnalyser<QUERY, DOCUMENT extends Identifiable>
implements RetrievalAnalyser<TRECResult, QUERY, DOCUMENT> {
    String additionalOptions = "-q -c";
    String toolPath = System.getenv("TREC_EVAL") != null ? System.getenv("TREC_EVAL") : (System.getProperty("TRECEval.path") != null ? System.getProperty("TRECEval.path") : (new File("/usr/local/bin/trec_eval").exists() ? "/usr/local/bin/trec_eval" : (new File("/usr/bin/trec_eval").exists() ? "/usr/bin/trec_eval" : "trec_eval")));

    @Override
    public TRECResult analyse(Map<QUERY, List<DOCUMENT>> results, Map<QUERY, Set<DOCUMENT>> relevant) {
        try {
            File qrels = File.createTempFile("openimaj_trec_eval", ".qrels");
            TRECEvalAnalyser.writeQRELS(relevant, new PrintStream(new FileOutputStream(qrels)));
            File top = File.createTempFile("trec_eval", ".top");
            TRECEvalAnalyser.writeTop(results, new PrintStream(new FileOutputStream(top)));
            ProcessBuilder pb = this.additionalOptions != null ? new ProcessBuilder(this.toolPath, this.additionalOptions, qrels.getAbsolutePath(), top.getAbsolutePath()) : new ProcessBuilder(this.toolPath, qrels.getAbsolutePath(), top.getAbsolutePath());
            Process proc = pb.start();
            StreamReader sysout = new StreamReader(proc.getInputStream());
            StreamReader syserr = new StreamReader(proc.getErrorStream());
            sysout.start();
            syserr.start();
            int rc = proc.waitFor();
            TRECResult analysis = new TRECResult(sysout.builder.toString());
            if (rc != 0) {
                System.err.println(pb.command());
                throw new RuntimeException("An error occurred running trec_eval: " + syserr.builder.toString());
            }
            qrels.delete();
            top.delete();
            return analysis;
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred running trec_eval.", e);
        }
    }

    public static <Q, D extends Identifiable> void writeTop(Map<Q, List<D>> results, PrintStream os) {
        TreeMap<String, ArrayList<RetrievalEvaluator.Document>> converted = IREvalAnalyser.convertResults(results);
        for (String query : converted.keySet()) {
            for (RetrievalEvaluator.Document d : converted.get(query)) {
                os.format("%s %d %s %d %f %s\n", query, 0, d.documentNumber, d.rank, d.score, "runid");
            }
        }
    }

    public static <Q, D extends Identifiable> void writeQRELS(Map<Q, Set<D>> relevant, PrintStream os) {
        TreeMap<String, ArrayList<RetrievalEvaluator.Judgment>> converted = IREvalAnalyser.convertRelevant(relevant);
        for (String query : converted.keySet()) {
            for (RetrievalEvaluator.Judgment j : converted.get(query)) {
                os.format("%s %d %s %d\n", query, 0, j.documentNumber, j.judgment);
            }
        }
    }

    static class StreamReader
    extends Thread {
        private StringBuilder builder = new StringBuilder();
        private BufferedReader br;

        public StreamReader(InputStream is) {
            this.br = new BufferedReader(new InputStreamReader(is));
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.br.readLine()) != null) {
                    this.builder.append(line);
                    this.builder.append("\n");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    this.br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

