/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.cluster.analyser;

import java.util.Map;
import org.openimaj.experiment.evaluation.cluster.analyser.ClusterAnalyser;
import org.openimaj.experiment.evaluation.cluster.analyser.ClusterAnalyserUtils;
import org.openimaj.experiment.evaluation.cluster.analyser.PurityAnalysis;
import org.openimaj.util.pair.IntIntPair;

public class PurityClusterAnalyser
implements ClusterAnalyser<PurityAnalysis> {
    @Override
    public PurityAnalysis analyse(int[][] correct, int[][] estimated) {
        Map<Integer, Integer> invCor = ClusterAnalyserUtils.invert(correct);
        Map<Integer, Integer> invEst = ClusterAnalyserUtils.invert(estimated);
        PurityAnalysis ret = new PurityAnalysis();
        double sumPurity = 0.0;
        for (int k = 0; k < estimated.length; ++k) {
            IntIntPair maxClassCount = ClusterAnalyserUtils.findMaxClassCount(estimated[k], invCor);
            sumPurity += (double)maxClassCount.second;
        }
        ret.purity = sumPurity / (double)invEst.size();
        return ret;
    }
}

