/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.classification.analysers.confusionmatrix;

import gov.sandia.cognition.learning.performance.categorization.ConfusionMatrix;
import net.sf.jasperreports.engine.JasperPrint;
import org.openimaj.experiment.evaluation.AnalysisResult;

public class CMResult<CLASS>
implements AnalysisResult {
    ConfusionMatrix<CLASS> matrix;

    public CMResult(ConfusionMatrix<CLASS> matrix) {
        this.matrix = matrix;
    }

    public ConfusionMatrix<CLASS> getMatrix() {
        return this.matrix;
    }

    public String toString() {
        return this.getSummaryReport();
    }

    @Override
    public JasperPrint getSummaryReport(String title, String info) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JasperPrint getDetailReport(String title, String info) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSummaryReport() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%10s: %2.3f\n", "Accuracy", this.matrix.getAccuracy()));
        sb.append(String.format("%10s: %2.3f\n", "Error Rate", this.matrix.getErrorRate()));
        return sb.toString();
    }

    @Override
    public String getDetailReport() {
        StringBuilder sb = new StringBuilder();
        sb.append("*********************** Overall Results ***********************\n");
        sb.append(String.format("%25s: %2.3f\n", "Total instances", this.matrix.getTotalCount()));
        sb.append(String.format("%25s: %2.3f\n", "Total correct", this.matrix.getTotalCorrectCount()));
        sb.append(String.format("%25s: %2.3f\n", "Total incorrect", this.matrix.getTotalIncorrectCount()));
        sb.append(String.format("%25s: %2.3f\n", "Accuracy", this.matrix.getAccuracy()));
        sb.append(String.format("%25s: %2.3f\n", "Error Rate", this.matrix.getErrorRate()));
        sb.append(String.format("%25s: %2.3f\n", "Average Class Accuracy", this.matrix.getAverageCategoryAccuracy()));
        sb.append(String.format("%25s: %2.3f\n", "Average Class Error Rate", this.matrix.getAverageCategoryErrorRate()));
        sb.append("\n");
        sb.append("********************** Per Class Results **********************\n");
        sb.append(String.format("%s\t", "Class"));
        sb.append(String.format("%s\t", "Class Accuracy"));
        sb.append(String.format("%s\t", "Class Error Rate"));
        sb.append(String.format("%s\t", "Actual Count"));
        sb.append(String.format("%s\n", "Predicted Count"));
        for (Object c : this.matrix.getActualCategories()) {
            sb.append(String.format("%10s\t", c));
            sb.append(String.format("%2.3f\t", this.matrix.getCategoryAccuracy(c)));
            sb.append(String.format("%2.3f\t", this.matrix.getCategoryErrorRate(c)));
            sb.append(String.format("%6f\t", this.matrix.getActualCount(c)));
            sb.append(String.format("%6f\n", this.matrix.getPredictedCount(c)));
        }
        return sb.toString();
    }
}

