/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.agreement;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openimaj.util.pair.ObjectFloatPair;

public class MajorityVoting {
    public static <A> ObjectFloatPair<A> calculateBasicMajorityVote(List<A> data) {
        HashMap<A, Integer> count = new HashMap<A, Integer>();
        for (A s : data) {
            if (count.get(s) == null) {
                count.put(s, 1);
                continue;
            }
            count.put(s, (Integer)count.get(s) + 1);
        }
        Object majority = null;
        int max = 0;
        for (Map.Entry x : count.entrySet()) {
            if ((Integer)x.getValue() > max) {
                max = (Integer)x.getValue();
                majority = x.getKey();
                continue;
            }
            if ((Integer)x.getValue() != max) continue;
            majority = null;
        }
        if (majority == null) {
            return null;
        }
        return new ObjectFloatPair(majority, (float)((Integer)count.get(majority)).intValue() / (float)data.size());
    }

    public static <A> Map<String, ObjectFloatPair<A>> calculateBasicMajorityVote(Map<String, List<A>> data) {
        HashMap<String, ObjectFloatPair<A>> out = new HashMap<String, ObjectFloatPair<A>>();
        for (Map.Entry<String, List<A>> x : data.entrySet()) {
            out.put(x.getKey(), MajorityVoting.calculateBasicMajorityVote(x.getValue()));
        }
        return out;
    }
}

