/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.dataset.cluster;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;
import org.openimaj.data.dataset.Dataset;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.MapBackedDataset;

public class ClusterEvalDataset
extends MapBackedDataset<String, ListBackedDataset<Integer>, Integer> {
    public ClusterEvalDataset(String loc) throws IOException {
        this(new File(loc));
    }

    public ClusterEvalDataset(File f) throws IOException {
        this(new FileInputStream(f));
    }

    public ClusterEvalDataset(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = reader.readLine()) != null) {
            String[] itemclusterparts = line.split(" ");
            int item = Integer.parseInt(itemclusterparts[0]);
            for (int i = 1; i < itemclusterparts.length; ++i) {
                String clusterLabel = itemclusterparts[i];
                ListBackedDataset list = (ListBackedDataset)this.get(clusterLabel);
                if (list == null) {
                    list = new ListBackedDataset();
                    this.put(clusterLabel, (Dataset)list);
                }
                list.add((Object)item);
            }
        }
    }

    public int[][] toClusters() {
        int[][] clusters = new int[this.size()][];
        int i = 0;
        for (Map.Entry is : this.entrySet()) {
            clusters[i] = new int[((ListBackedDataset)is.getValue()).size()];
            int j = 0;
            Iterator iterator = ((ListBackedDataset)is.getValue()).iterator();
            while (iterator.hasNext()) {
                int js = (Integer)iterator.next();
                clusters[i][j++] = js;
            }
            ++i;
        }
        return clusters;
    }
}

