/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.agent;

import com.bethecoder.ascii_table.ASCIITable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.openimaj.time.NanoTimer;
import org.openimaj.time.Timer;

public class TimeTracker {
    private static Map<String, SummaryStatistics> times = new HashMap<String, SummaryStatistics>();

    public static synchronized void accumulate(String identifier, NanoTimer timer) {
        TimeTracker.accumulate(identifier, timer.duration());
    }

    public static synchronized void accumulate(String identifier, Timer timer) {
        TimeTracker.accumulate(identifier, (long)((double)timer.duration() * 1000000.0));
    }

    public static synchronized void accumulate(String identifier, long nanoTime) {
        SummaryStatistics t = times.get(identifier);
        if (t == null) {
            t = new SummaryStatistics();
            times.put(identifier, t);
        }
        t.addValue((double)nanoTime);
    }

    public static synchronized Map<String, SummaryStatistics> reset() {
        Map<String, SummaryStatistics> oldTimes = times;
        times = new HashMap<String, SummaryStatistics>();
        return oldTimes;
    }

    public static synchronized Map<String, SummaryStatistics> getTimes() {
        HashMap<String, SummaryStatistics> ret = new HashMap<String, SummaryStatistics>();
        for (Map.Entry<String, SummaryStatistics> e : times.entrySet()) {
            ret.put(e.getKey(), e.getValue().copy());
        }
        return ret;
    }

    public static void addMissing(Map<String, SummaryStatistics> timesToAdd) {
        for (Map.Entry<String, SummaryStatistics> e : timesToAdd.entrySet()) {
            if (times.containsKey(e.getValue())) continue;
            times.put(e.getKey(), e.getValue());
        }
    }

    public static String format(Map<String, SummaryStatistics> times) {
        String[] header = new String[]{"Timer Identifier", "Recorded Time"};
        String[][] data = new String[times.size()][];
        int i = 0;
        for (Map.Entry<String, SummaryStatistics> e : times.entrySet()) {
            data[i++] = new String[]{e.getKey(), TimeTracker.format(e.getValue())};
        }
        return ASCIITable.getInstance().getTable(header, data);
    }

    public static String format(SummaryStatistics ss) {
        if (ss.getN() == 1L) {
            return TimeTracker.formatTime(ss.getMean());
        }
        return TimeTracker.formatTime(ss.getMean(), ss.getStandardDeviation());
    }

    private static String formatTime(double time) {
        long ns = (long)time;
        if ((double)ns < 1000.0) {
            return time + "ns";
        }
        if ((double)ns < 1000000.0) {
            return time / 1000.0 + "us";
        }
        if ((double)ns < 1.0E9) {
            return time / 1000000.0 + "ms";
        }
        double secs = time / 1.0E9;
        if (secs < 60.0) {
            return String.format("%2.5ss", secs);
        }
        long mins = (long)(secs / 60.0);
        double rsecs = secs - (double)(mins * 60L);
        if (mins < 60L) {
            return mins + "m" + String.format("%2.5ss", rsecs);
        }
        long hrs = mins / 60L;
        long rmins = mins - hrs * 60L;
        if (hrs < 24L) {
            return hrs + "h" + rmins + "m" + String.format("%2.5ss", rsecs);
        }
        long days = hrs / 24L;
        long rhrs = days - hrs * 24L;
        if (hrs < 24L) {
            return days + "d" + rhrs + "h" + rmins + "m" + String.format("%2.5ss", rsecs);
        }
        return time + "ns";
    }

    private static String formatTime(double mean, double standardDeviation) {
        return TimeTracker.formatTime(mean) + " (SD = " + TimeTracker.formatTime(standardDeviation) + ")";
    }
}

