/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.montecarlo;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.statistics.ProbabilityDensityFunction;
import gov.sandia.cognition.statistics.ProbabilityFunction;
import gov.sandia.cognition.statistics.montecarlo.MonteCarloSampler;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.DefaultWeightedValue;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.WeightedValue;
import java.util.ArrayList;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Importance Sampling", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Importance_sampling")
public class ImportanceSampler<DataType>
extends AbstractCloneableSerializable
implements MonteCarloSampler<DataType, WeightedValue<DataType>, Evaluator<? super DataType, Double>> {
    private ProbabilityFunction<DataType> importanceDistribution;

    public ImportanceSampler() {
        this(null);
    }

    public ImportanceSampler(ProbabilityDensityFunction<DataType> importanceDistribution) {
        this.setImportanceDistribution(importanceDistribution);
    }

    public ImportanceSampler<DataType> clone() {
        ImportanceSampler clone = (ImportanceSampler)super.clone();
        clone.setImportanceDistribution((ProbabilityFunction)ObjectUtil.cloneSafe(this.getImportanceDistribution()));
        return clone;
    }

    @Override
    public ArrayList<DefaultWeightedValue<DataType>> sample(Evaluator<? super DataType, Double> targetFunction, Random random, int numSamples) {
        ArrayList importanceSamples = this.importanceDistribution.sample(random, numSamples);
        ArrayList<DefaultWeightedValue<DataType>> weightedSamples = new ArrayList<DefaultWeightedValue<DataType>>(numSamples);
        for (Object importanceSample : importanceSamples) {
            double weight = (Double)targetFunction.evaluate(importanceSample) / (Double)this.importanceDistribution.evaluate(importanceSample);
            weightedSamples.add(new DefaultWeightedValue(importanceSample, weight));
        }
        return weightedSamples;
    }

    public ProbabilityFunction<DataType> getImportanceDistribution() {
        return this.importanceDistribution;
    }

    public void setImportanceDistribution(ProbabilityFunction<DataType> importanceDistribution) {
        this.importanceDistribution = importanceDistribution;
    }
}

