/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.statistics.method.ConfidenceInterval;
import gov.sandia.cognition.statistics.method.ConfidenceIntervalEvaluator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.Collection;

@PublicationReference(author={"Wikipedia"}, title="Markov's Inequality", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Markov%27s_inequality")
public class MarkovInequality
extends AbstractCloneableSerializable
implements ConfidenceIntervalEvaluator<Collection<Double>> {
    public static final MarkovInequality INSTANCE = new MarkovInequality();

    @Override
    public ConfidenceInterval computeConfidenceInterval(Collection<Double> data, double confidence) {
        double sampleMean = 0.0;
        for (Double value : data) {
            sampleMean += Math.abs(value);
        }
        if (!data.isEmpty()) {
            sampleMean /= (double)data.size();
        }
        return MarkovInequality.computeConfidenceInterval(sampleMean, data.size(), confidence);
    }

    public static ConfidenceInterval computeConfidenceInterval(double sampleMean, int numSamples, double confidence) {
        if (confidence <= 0.0 || confidence > 1.0) {
            throw new IllegalArgumentException("Confidence must be 0 < confidence <= 1");
        }
        double a = confidence < 1.0 ? sampleMean / (1.0 - confidence) : Double.POSITIVE_INFINITY;
        return new ConfidenceInterval(sampleMean, -a, a, confidence, numSamples);
    }

    @Override
    public ConfidenceInterval computeConfidenceInterval(double mean, double variance, int numSamples, double confidence) {
        return MarkovInequality.computeConfidenceInterval(mean, numSamples, confidence);
    }
}

