/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.statistics.method.AbstractMultipleHypothesisComparison;
import gov.sandia.cognition.statistics.method.ConfidenceStatistic;
import gov.sandia.cognition.statistics.method.NullHypothesisEvaluator;
import gov.sandia.cognition.statistics.method.StudentTConfidence;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractPairwiseMultipleHypothesisComparison<StatisticType extends Statistic>
extends AbstractMultipleHypothesisComparison<Collection<? extends Number>, StatisticType> {
    public static final NullHypothesisEvaluator<Collection<? extends Number>> DEFAULT_PAIRWISE_TEST = StudentTConfidence.INSTANCE;
    protected NullHypothesisEvaluator<Collection<? extends Number>> pairwiseTest;

    public AbstractPairwiseMultipleHypothesisComparison(NullHypothesisEvaluator<Collection<? extends Number>> pairwiseTest) {
        this.setPairwiseTest(pairwiseTest);
    }

    public AbstractPairwiseMultipleHypothesisComparison<StatisticType> clone() {
        AbstractPairwiseMultipleHypothesisComparison clone = (AbstractPairwiseMultipleHypothesisComparison)super.clone();
        clone.setPairwiseTest((NullHypothesisEvaluator)ObjectUtil.cloneSafe(this.getPairwiseTest()));
        return clone;
    }

    public NullHypothesisEvaluator<Collection<? extends Number>> getPairwiseTest() {
        return this.pairwiseTest;
    }

    public void setPairwiseTest(NullHypothesisEvaluator<Collection<? extends Number>> pairwiseTest) {
        this.pairwiseTest = pairwiseTest;
    }

    public static abstract class Statistic
    extends AbstractMultipleHypothesisComparison.Statistic {
        protected ArrayList<ArrayList<ConfidenceStatistic>> pairwiseTestStatistics;

        public Statistic(Collection<? extends Collection<? extends Number>> data, double uncompensatedAlpha, NullHypothesisEvaluator<Collection<? extends Number>> pairwiseTest) {
            this.treatmentCount = data.size();
            this.uncompensatedAlpha = uncompensatedAlpha;
            this.computePairwiseTestResults(data, pairwiseTest);
        }

        @Override
        public Statistic clone() {
            Statistic clone = (Statistic)super.clone();
            clone.pairwiseTestStatistics = ObjectUtil.cloneSmartElementsAsArrayList(this.getPairwiseTestStatistics());
            return clone;
        }

        protected void computePairwiseTestResults(Collection<? extends Collection<? extends Number>> data, NullHypothesisEvaluator<Collection<? extends Number>> pairwiseTest) {
            int j;
            int i;
            ArrayList treatments = CollectionUtil.asArrayList(data);
            int K = treatments.size();
            Matrix Z = MatrixFactory.getDefault().createMatrix(K, K);
            Matrix P = MatrixFactory.getDefault().createMatrix(K, K);
            ArrayList stats = new ArrayList(K);
            for (i = 0; i < K; ++i) {
                ArrayList<Object> comp = new ArrayList<Object>(K);
                for (j = 0; j < K; ++j) {
                    comp.add(null);
                }
                stats.add(comp);
            }
            for (i = 0; i < K; ++i) {
                Z.setElement(i, i, 0.0);
                P.setElement(i, i, 1.0);
                Collection datai = (Collection)treatments.get(i);
                for (j = i + 1; j < K; ++j) {
                    Collection dataj = (Collection)treatments.get(j);
                    ConfidenceStatistic comparison = pairwiseTest.evaluateNullHypothesis(datai, dataj);
                    double pij = comparison.getNullHypothesisProbability();
                    double zij = comparison.getTestStatistic();
                    Z.setElement(i, j, zij);
                    Z.setElement(j, i, zij);
                    P.setElement(i, j, pij);
                    P.setElement(j, i, pij);
                    ((ArrayList)stats.get(i)).set(j, comparison);
                    ((ArrayList)stats.get(j)).set(i, comparison);
                }
            }
            this.testStatistics = Z;
            this.nullHypothesisProbabilities = P;
            this.pairwiseTestStatistics = stats;
        }

        public ArrayList<ArrayList<ConfidenceStatistic>> getPairwiseTestStatistics() {
            return this.pairwiseTestStatistics;
        }

        @Override
        public boolean acceptNullHypothesis(int i, int j) {
            return this.getNullHypothesisProbability(i, j) >= this.getAdjustedAlpha(i, j);
        }

        public abstract double getAdjustedAlpha(int var1, int var2);
    }
}

