/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.MathUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormSmoothUnivariateDistribution;
import gov.sandia.cognition.statistics.SmoothCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.UnivariateProbabilityDensityFunction;
import java.util.ArrayList;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Weibull Distribution", type=PublicationType.WebPage, year=2010, url="http://en.wikipedia.org/wiki/Weibull_distribution")
public class WeibullDistribution
extends AbstractClosedFormSmoothUnivariateDistribution {
    public static final double DEFAULT_SHAPE = 1.0;
    public static final double DEFAULT_SCALE = 1.0;
    protected double shape;
    protected double scale;

    public WeibullDistribution() {
        this(1.0, 1.0);
    }

    public WeibullDistribution(double shape, double scale) {
        this.shape = shape;
        this.scale = scale;
    }

    public WeibullDistribution(WeibullDistribution other) {
        this(other.getShape(), other.getScale());
    }

    @Override
    public WeibullDistribution clone() {
        return (WeibullDistribution)super.clone();
    }

    public double getShape() {
        return this.shape;
    }

    public void setShape(double shape) {
        if (shape <= 0.0) {
            throw new IllegalArgumentException("Shape must be > 0.0");
        }
        this.shape = shape;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Scale must be > 0.0");
        }
        this.scale = scale;
    }

    @Override
    public Double getMean() {
        return this.scale * Math.exp(MathUtil.logGammaFunction((double)(1.0 + 1.0 / this.shape)));
    }

    @Override
    public double getVariance() {
        double mean = this.getMean();
        return this.scale * this.scale * Math.exp(MathUtil.logGammaFunction((double)(1.0 + 2.0 / this.shape))) - mean * mean;
    }

    @Override
    public ArrayList<Double> sample(Random random, int numSamples) {
        ArrayList<Double> samples = new ArrayList<Double>(numSamples);
        double exp = 1.0 / this.shape;
        for (int n = 0; n < numSamples; ++n) {
            double u = random.nextDouble();
            samples.add(this.scale * Math.pow(-Math.log(u), exp));
        }
        return samples;
    }

    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(new double[]{this.getShape(), this.getScale()});
    }

    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(2);
        this.setShape(parameters.getElement(0));
        this.setScale(parameters.getElement(1));
    }

    @Override
    public Double getMinSupport() {
        return 0.0;
    }

    @Override
    public Double getMaxSupport() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public PDF getProbabilityFunction() {
        return new PDF(this);
    }

    @Override
    public CDF getCDF() {
        return new CDF(this);
    }

    public static class CDF
    extends WeibullDistribution
    implements SmoothCumulativeDistributionFunction {
        public CDF() {
        }

        public CDF(double shape, double scale) {
            super(shape, scale);
        }

        public CDF(WeibullDistribution other) {
            super(other);
        }

        @Override
        public PDF getDerivative() {
            return this.getProbabilityFunction();
        }

        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        public double evaluate(double input) {
            if (input < 0.0) {
                return 0.0;
            }
            return 1.0 - Math.exp(-Math.pow(input / this.scale, this.shape));
        }

        public Double differentiate(Double input) {
            return this.getDerivative().evaluate(input);
        }

        @Override
        public CDF getCDF() {
            return this;
        }
    }

    public static class PDF
    extends WeibullDistribution
    implements UnivariateProbabilityDensityFunction {
        public PDF() {
        }

        public PDF(double shape, double scale) {
            super(shape, scale);
        }

        public PDF(WeibullDistribution other) {
            super(other);
        }

        @Override
        public double logEvaluate(Double input) {
            return this.logEvaluate((double)input);
        }

        @Override
        public double logEvaluate(double input) {
            if (input < 0.0) {
                return Math.log(0.0);
            }
            double logSum = 0.0;
            logSum += Math.log(this.shape / this.scale);
            logSum += (this.shape - 1.0) * Math.log(input / this.scale);
            return logSum -= Math.pow(input / this.scale, this.shape);
        }

        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        public double evaluate(double input) {
            return Math.exp(this.logEvaluate(input));
        }

        @Override
        public PDF getProbabilityFunction() {
            return this;
        }
    }
}

