/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.AbstractUnivariateScalarFunction;
import gov.sandia.cognition.math.UnivariateScalarFunction;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormSmoothUnivariateDistribution;
import gov.sandia.cognition.statistics.AbstractIncrementalEstimator;
import gov.sandia.cognition.statistics.AbstractSufficientStatistic;
import gov.sandia.cognition.statistics.DistributionEstimator;
import gov.sandia.cognition.statistics.DistributionWeightedEstimator;
import gov.sandia.cognition.statistics.EstimableDistribution;
import gov.sandia.cognition.statistics.InvertibleCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.SmoothCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.UnivariateProbabilityDensityFunction;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ArgumentChecker;
import gov.sandia.cognition.util.Pair;
import gov.sandia.cognition.util.WeightedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Normal distribution", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Normal_distribution")
public class UnivariateGaussian
extends AbstractClosedFormSmoothUnivariateDistribution
implements EstimableDistribution<Double, UnivariateGaussian> {
    public static final double DEFAULT_MEAN = 0.0;
    public static final double DEFAULT_VARIANCE = 1.0;
    protected double mean;
    protected double variance;
    public static final double BIG_Z = 100.0;
    public static final double SQRT2 = Math.sqrt(2.0);
    public static final double PI2 = Math.PI * 2;

    public UnivariateGaussian() {
        this(0.0, 1.0);
    }

    public UnivariateGaussian(double mean, double variance) {
        this.setMean(mean);
        this.setVariance(variance);
    }

    public UnivariateGaussian(UnivariateGaussian other) {
        this(other.getMean(), other.getVariance());
    }

    @Override
    public UnivariateGaussian clone() {
        return (UnivariateGaussian)super.clone();
    }

    @Override
    public Double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    @Override
    public double getVariance() {
        return this.variance;
    }

    public void setVariance(double variance) {
        ArgumentChecker.assertIsPositive((String)"variance", (double)variance);
        this.variance = variance;
    }

    public String toString() {
        return "Mean: " + this.getMean() + " Variance: " + this.getVariance();
    }

    @Override
    public ArrayList<Double> sample(Random random, int numSamples) {
        ArrayList<Double> samples = new ArrayList<Double>(numSamples);
        double stddev = Math.sqrt(this.getVariance());
        for (int n = 0; n < numSamples; ++n) {
            double x = random.nextGaussian();
            samples.add(x * stddev + this.mean);
        }
        return samples;
    }

    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(new double[]{this.getMean(), this.getVariance()});
    }

    public void convertFromVector(Vector parameters) {
        if (parameters.getDimensionality() != 2) {
            throw new IllegalArgumentException("Must have parameters of dimension 2");
        }
        this.setMean(parameters.getElement(0));
        this.setVariance(parameters.getElement(1));
    }

    @Override
    public CDF getCDF() {
        return new CDF(this);
    }

    @Override
    public PDF getProbabilityFunction() {
        return new PDF(this);
    }

    @Override
    public Double getMinSupport() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public Double getMaxSupport() {
        return Double.POSITIVE_INFINITY;
    }

    public UnivariateGaussian times(UnivariateGaussian other) {
        double m1 = this.getMean();
        double v1 = this.getVariance();
        double m2 = other.getMean();
        double v2 = other.getVariance();
        double vhat = 1.0 / (1.0 / v1 + 1.0 / v2);
        double meanHat = vhat / v1 * m1 + vhat / v2 * m2;
        return new UnivariateGaussian(meanHat, vhat);
    }

    public UnivariateGaussian convolve(UnivariateGaussian other) {
        double meanHat = this.getMean() + other.getMean();
        double varianceHat = this.getVariance() + other.getVariance();
        return new UnivariateGaussian(meanHat, varianceHat);
    }

    public MaximumLikelihoodEstimator getEstimator() {
        return new MaximumLikelihoodEstimator();
    }

    public static class IncrementalEstimator
    extends AbstractIncrementalEstimator<Double, UnivariateGaussian, SufficientStatistic> {
        public static final double DEFAULT_DEFAULT_VARIANCE = 1.0E-5;
        protected double defaultVariance;

        public IncrementalEstimator() {
            this(1.0E-5);
        }

        public IncrementalEstimator(double defaultVariance) {
            this.setDefaultVariance(defaultVariance);
        }

        @Override
        public SufficientStatistic createInitialLearnedObject() {
            return new SufficientStatistic(this.getDefaultVariance());
        }

        public double getDefaultVariance() {
            return this.defaultVariance;
        }

        public void setDefaultVariance(double defaultVariance) {
            ArgumentChecker.assertIsNonNegative((String)"defaultVariance", (double)defaultVariance);
            this.defaultVariance = defaultVariance;
        }
    }

    @PublicationReference(author={"Wikipedia"}, title="Algorithms for calculating variance", year=2011, type=PublicationType.WebPage, url="http://en.wikipedia.org/wiki/Algorithms_for_calculating_variance")
    public static class SufficientStatistic
    extends AbstractSufficientStatistic<Double, UnivariateGaussian> {
        protected double mean;
        protected double sumSquaredDifferences;

        public SufficientStatistic() {
            this(0.0);
        }

        public SufficientStatistic(double defaultVariance) {
            ArgumentChecker.assertIsNonNegative((String)"defaultVariance", (double)defaultVariance);
            this.clear();
            this.sumSquaredDifferences = defaultVariance;
        }

        @Override
        public SufficientStatistic clone() {
            return (SufficientStatistic)super.clone();
        }

        public void clear() {
            this.count = 0L;
            this.mean = 0.0;
            this.sumSquaredDifferences = 0.0;
        }

        public PDF create() {
            PDF result = new PDF();
            this.create(result);
            return result;
        }

        @Override
        public void create(UnivariateGaussian distribution) {
            distribution.setMean(this.getMean());
            distribution.setVariance(this.getVariance());
        }

        @Override
        public void update(Double value) {
            this.update((double)value);
        }

        @Override
        public void update(double value) {
            ++this.count;
            double delta = value - this.mean;
            this.mean += delta / (double)this.count;
            this.sumSquaredDifferences += delta * (value - this.mean);
        }

        public SufficientStatistic plus(SufficientStatistic other) {
            SufficientStatistic copy = this.clone();
            copy.plusEquals(other);
            return copy;
        }

        public void plusEquals(SufficientStatistic other) {
            double delta = other.mean - this.mean;
            long newCount = this.count + other.count;
            double newMean = this.mean + delta * (double)other.count / (double)newCount;
            double newSumSquaredDifferences = this.sumSquaredDifferences + other.sumSquaredDifferences + delta * delta * (double)this.count * (double)other.count / (double)newCount;
            this.count = newCount;
            this.sumSquaredDifferences = newSumSquaredDifferences;
            this.mean = newMean;
        }

        public double getMean() {
            return this.mean;
        }

        public double getVariance() {
            if (this.count <= 1L) {
                return this.sumSquaredDifferences;
            }
            return this.sumSquaredDifferences / (double)(this.count - 1L);
        }

        public double getSumSquaredDifferences() {
            return this.sumSquaredDifferences;
        }
    }

    public static class WeightedMaximumLikelihoodEstimator
    extends AbstractCloneableSerializable
    implements DistributionWeightedEstimator<Double, PDF> {
        private double defaultVariance;

        public WeightedMaximumLikelihoodEstimator() {
            this(1.0E-5);
        }

        public WeightedMaximumLikelihoodEstimator(double defaultVariance) {
            this.defaultVariance = defaultVariance;
        }

        @Override
        public PDF learn(Collection<? extends WeightedValue<? extends Double>> data) {
            return WeightedMaximumLikelihoodEstimator.learn(data, this.defaultVariance);
        }

        public static PDF learn(Collection<? extends WeightedValue<? extends Number>> data, double defaultVariance) {
            Pair mle = UnivariateStatisticsUtil.computeWeightedMeanAndVariance(data);
            double mean = (Double)mle.getFirst();
            double variance = (Double)mle.getSecond();
            return new PDF(mean, variance += defaultVariance);
        }
    }

    public static class MaximumLikelihoodEstimator
    extends AbstractCloneableSerializable
    implements DistributionEstimator<Double, PDF> {
        private double defaultVariance;
        public static final double DEFAULT_VARIANCE = 1.0E-5;

        public MaximumLikelihoodEstimator() {
            this(1.0E-5);
        }

        public MaximumLikelihoodEstimator(double defaultVariance) {
            this.setDefaultVariance(defaultVariance);
        }

        @Override
        public PDF learn(Collection<? extends Double> data) {
            return MaximumLikelihoodEstimator.learn(data, this.defaultVariance);
        }

        public static PDF learn(Collection<? extends Number> data, double defaultVariance) {
            Pair mle = UnivariateStatisticsUtil.computeMeanAndVariance(data);
            double mean = (Double)mle.getFirst();
            double variance = (Double)mle.getSecond();
            return new PDF(mean, variance += defaultVariance);
        }

        public double getDefaultVariance() {
            return this.defaultVariance;
        }

        public void setDefaultVariance(double defaultVariance) {
            ArgumentChecker.assertIsNonNegative((String)"defaultVariance", (double)defaultVariance);
            this.defaultVariance = defaultVariance;
        }
    }

    public static class PDF
    extends UnivariateGaussian
    implements UnivariateProbabilityDensityFunction {
        public PDF() {
        }

        public PDF(double mean, double variance) {
            super(mean, variance);
        }

        public PDF(UnivariateGaussian other) {
            super(other.getMean(), other.getVariance());
        }

        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        public double evaluate(double input) {
            return PDF.evaluate(input, (Double)this.getMean(), this.getVariance());
        }

        public static double evaluate(double input, double mean, double variance) {
            return Math.exp(PDF.logEvaluate(input, mean, variance));
        }

        @Override
        public double logEvaluate(Double input) {
            return PDF.logEvaluate(input, this.mean, this.variance);
        }

        @Override
        public double logEvaluate(double input) {
            return PDF.logEvaluate(input, this.mean, this.variance);
        }

        public static double logEvaluate(double input, double mean, double variance) {
            double delta = input - mean;
            double exponent = delta * delta / (-2.0 * variance);
            double coefficient = -0.5 * Math.log(Math.PI * 2 * variance);
            return exponent + coefficient;
        }

        @Override
        public PDF getProbabilityFunction() {
            return this;
        }
    }

    public static class CDF
    extends UnivariateGaussian
    implements SmoothCumulativeDistributionFunction,
    InvertibleCumulativeDistributionFunction<Double> {
        public CDF() {
        }

        public CDF(double mean, double variance) {
            super(mean, variance);
        }

        public CDF(UnivariateGaussian other) {
            super(other.getMean(), other.getVariance());
        }

        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        public double evaluate(double z) {
            return CDF.evaluate(z, this.mean, this.variance);
        }

        public static double evaluate(double z, double mean, double variance) {
            double zstar = (z - mean) / Math.sqrt(variance);
            double retval = zstar == 0.0 ? 0.5 : 0.5 * (1.0 + ErrorFunction.INSTANCE.evaluate(zstar / SQRT2));
            if (retval < 0.0) {
                retval = 0.0;
            } else if (retval > 1.0) {
                retval = 1.0;
            }
            return retval;
        }

        @Override
        public CDF getCDF() {
            return this;
        }

        @Override
        public PDF getDerivative() {
            return this.getProbabilityFunction();
        }

        public Double differentiate(Double input) {
            return this.getDerivative().evaluate(input);
        }

        @Override
        public Double inverse(double probability) {
            return Inverse.evaluate(probability, this.mean, this.variance);
        }

        public static class Inverse
        extends UnivariateGaussian
        implements UnivariateScalarFunction {
            public Inverse() {
            }

            public Inverse(double mean, double variance) {
                super(mean, variance);
            }

            public Inverse(UnivariateGaussian other) {
                super(other.getMean(), other.getVariance());
            }

            public Double evaluate(Double input) {
                return this.evaluate((double)input);
            }

            public double evaluate(double p) {
                return Inverse.evaluate(p, this.mean, this.variance);
            }

            public static double evaluate(double p, double mean, double variance) {
                double stddev = Math.sqrt(variance);
                if (p <= 0.0) {
                    return Double.NEGATIVE_INFINITY;
                }
                if (p >= 1.0) {
                    return Double.POSITIVE_INFINITY;
                }
                double stdinv = SQRT2 * ErrorFunction.Inverse.INSTANCE.evaluate(2.0 * p - 1.0);
                return mean + stddev * stdinv;
            }
        }
    }

    @PublicationReference(title="ErrorFunction.java", author={"Robert Sedgewick", "Kevin Wayne"}, type=PublicationType.WebPage, year=2007, url="http://www.cs.princeton.edu/introcs/21function/ErrorFunction.java.html")
    public static class ErrorFunction
    extends AbstractUnivariateScalarFunction {
        public static final ErrorFunction INSTANCE = new ErrorFunction();

        public double evaluate(double z) {
            double t = 1.0 / (1.0 + 0.5 * Math.abs(z));
            double ans = 1.0 - t * Math.exp(-z * z - 1.26551223 + t * (1.00002368 + t * (0.37409196 + t * (0.09678418 + t * (-0.18628806 + t * (0.27886807 + t * (-1.13520398 + t * (1.48851587 + t * (-0.82215223 + t * 0.17087277)))))))));
            if (z < 0.0) {
                ans = -ans;
            }
            return ans;
        }

        public static class Inverse
        extends AbstractUnivariateScalarFunction {
            public static final Inverse INSTANCE = new Inverse();

            public double evaluate(double y) {
                double x;
                if (Math.abs(y) < 1.0) {
                    double z;
                    double y0 = 0.7;
                    if (Math.abs(y) <= 0.7) {
                        double[] a = new double[]{0.886226899, -1.645349621, 0.914624893, -0.140543331};
                        double[] b = new double[]{-2.118377725, 1.442710462, -0.329097515, 0.012229801};
                        z = y * y;
                        x = y * (((a[3] * z + a[2]) * z + a[1]) * z + a[0]) / ((((b[3] * z + b[2]) * z + b[1]) * z + b[0]) * z + 1.0);
                    } else {
                        double[] c = new double[]{-1.970840454, -1.624906493, 3.429567803, 1.641345311};
                        double[] d = new double[]{3.5438892, 1.6370678};
                        if (0.7 < y) {
                            z = Math.sqrt(-Math.log((1.0 - y) / 2.0));
                            x = (((c[3] * z + c[2]) * z + c[1]) * z + c[0]) / ((d[1] * z + d[0]) * z + 1.0);
                        } else {
                            z = Math.sqrt(-Math.log((1.0 + y) / 2.0));
                            x = -(((c[3] * z + c[2]) * z + c[1]) * z + c[0]) / ((d[1] * z + d[0]) * z + 1.0);
                        }
                    }
                    double COEF = 2.0 / Math.sqrt(Math.PI);
                    for (int i = 0; i < 2; ++i) {
                        double erfx = INSTANCE.evaluate(x);
                        x -= (erfx - y) / (COEF * Math.exp(-x * x));
                    }
                } else {
                    x = y >= 1.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                }
                return x;
            }
        }
    }
}

