/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.MathUtil;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormSmoothUnivariateDistribution;
import gov.sandia.cognition.statistics.DistributionEstimator;
import gov.sandia.cognition.statistics.DistributionWeightedEstimator;
import gov.sandia.cognition.statistics.EstimableDistribution;
import gov.sandia.cognition.statistics.InvertibleCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.SmoothCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.UnivariateProbabilityDensityFunction;
import gov.sandia.cognition.statistics.distribution.BetaDistribution;
import gov.sandia.cognition.statistics.distribution.ChiSquareDistribution;
import gov.sandia.cognition.statistics.method.InverseTransformSampling;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Pair;
import gov.sandia.cognition.util.WeightedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@PublicationReferences(references={@PublicationReference(author={"Christopher Bishop"}, title="Pattern Recognition and Machine Learning", type=PublicationType.Book, year=2006, pages={102, 105}), @PublicationReference(author={"Wikipedia"}, title="Student's t-distribution", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Student_t_distribution")})
public class StudentTDistribution
extends AbstractClosedFormSmoothUnivariateDistribution
implements EstimableDistribution<Double, StudentTDistribution> {
    public static final double DEFAULT_DEGREES_OF_FREEDOM = 3.0;
    public static final double DEFAULT_MEAN = 0.0;
    public static final double DEFAULT_PRECISION = 1.0;
    protected double precision;
    protected double mean;
    protected double degreesOfFreedom;

    public StudentTDistribution() {
        this(3.0);
    }

    public StudentTDistribution(double degreesOfFreedom) {
        this(degreesOfFreedom, 0.0, 1.0);
    }

    public StudentTDistribution(double degreesOfFreedom, double mean, double precision) {
        this.setDegreesOfFreedom(degreesOfFreedom);
        this.setPrecision(precision);
        this.setMean(mean);
    }

    public StudentTDistribution(StudentTDistribution other) {
        this(other.getDegreesOfFreedom(), other.getMean(), other.getPrecision());
    }

    @Override
    public StudentTDistribution clone() {
        return (StudentTDistribution)super.clone();
    }

    public double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    public void setDegreesOfFreedom(double degreesOfFreedom) {
        if (degreesOfFreedom <= 0.0) {
            throw new IllegalArgumentException("DOF must be > 0.0");
        }
        this.degreesOfFreedom = degreesOfFreedom;
    }

    @Override
    public double getVariance() {
        double v = this.getDegreesOfFreedom();
        if (v > 2.0) {
            return v / (v - 2.0) / this.precision;
        }
        return Double.POSITIVE_INFINITY;
    }

    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(new double[]{this.getDegreesOfFreedom(), this.getMean(), this.getPrecision()});
    }

    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(3);
        this.setDegreesOfFreedom(parameters.getElement(0));
        this.setMean(parameters.getElement(1));
        this.setPrecision(parameters.getElement(2));
    }

    @Override
    public ArrayList<Double> sample(Random random, int numSamples) {
        ArrayList<Double> Vs = ChiSquareDistribution.sample(this.degreesOfFreedom, random, numSamples);
        ArrayList<Double> samples = new ArrayList<Double>(numSamples);
        double sp = Math.sqrt(this.precision);
        for (int n = 0; n < numSamples; ++n) {
            double z = random.nextGaussian() / sp;
            double v = Vs.get(n);
            samples.add(z * Math.sqrt(this.degreesOfFreedom / v) + this.mean);
        }
        return samples;
    }

    @Override
    public CDF getCDF() {
        return new CDF(this);
    }

    @Override
    public PDF getProbabilityFunction() {
        return new PDF(this);
    }

    public double getPrecision() {
        return this.precision;
    }

    public void setPrecision(double precision) {
        if (precision <= 0.0) {
            throw new IllegalArgumentException("Precision must be > 0.0");
        }
        this.precision = precision;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    @Override
    public Double getMean() {
        return this.mean;
    }

    @Override
    public Double getMinSupport() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public Double getMaxSupport() {
        return Double.POSITIVE_INFINITY;
    }

    public String toString() {
        return "Mean: " + this.getMean() + ", Variance: " + 1.0 / this.getPrecision() + ", DOF: " + this.getDegreesOfFreedom();
    }

    public MaximumLikelihoodEstimator getEstimator() {
        return new MaximumLikelihoodEstimator();
    }

    public static class WeightedMaximumLikelihoodEstimator
    extends AbstractCloneableSerializable
    implements DistributionWeightedEstimator<Double, StudentTDistribution> {
        private double defaultVariance;

        public WeightedMaximumLikelihoodEstimator() {
            this(1.0E-5);
        }

        public WeightedMaximumLikelihoodEstimator(double defaultVariance) {
            this.defaultVariance = defaultVariance;
        }

        @Override
        public PDF learn(Collection<? extends WeightedValue<? extends Double>> data) {
            return WeightedMaximumLikelihoodEstimator.learn(data, this.defaultVariance);
        }

        public static PDF learn(Collection<? extends WeightedValue<? extends Double>> data, double defaultVariance) {
            Pair mle = UnivariateStatisticsUtil.computeWeightedMeanAndVariance(data);
            double kurtosis = UnivariateStatisticsUtil.computeWeightedKurtosis(data);
            double mean = (Double)mle.getFirst();
            double variance = (Double)mle.getSecond();
            double dofs = 6.0 / (Math.abs(kurtosis) + defaultVariance) + 4.0;
            double precision = dofs / ((variance += defaultVariance) * (dofs - 2.0));
            return new PDF(dofs, mean, precision);
        }
    }

    public static class MaximumLikelihoodEstimator
    extends AbstractCloneableSerializable
    implements DistributionEstimator<Double, StudentTDistribution> {
        private double defaultVariance;
        public static final double DEFAULT_VARIANCE = 1.0E-5;

        public MaximumLikelihoodEstimator() {
            this(1.0E-5);
        }

        public MaximumLikelihoodEstimator(double defaultVariance) {
            this.defaultVariance = defaultVariance;
        }

        @Override
        public StudentTDistribution learn(Collection<? extends Double> data) {
            return MaximumLikelihoodEstimator.learn(data, this.defaultVariance);
        }

        public static PDF learn(Collection<? extends Double> data, double defaultVariance) {
            Pair mle = UnivariateStatisticsUtil.computeMeanAndVariance(data);
            double kurtosis = UnivariateStatisticsUtil.computeKurtosis(data);
            double mean = (Double)mle.getFirst();
            double variance = (Double)mle.getSecond();
            double dofs = 6.0 / (kurtosis + defaultVariance) + 4.0;
            double precision = dofs / ((variance += defaultVariance) * (dofs - 2.0));
            return new PDF(dofs, mean, precision);
        }
    }

    public static class CDF
    extends StudentTDistribution
    implements SmoothCumulativeDistributionFunction,
    InvertibleCumulativeDistributionFunction<Double> {
        public CDF() {
        }

        public CDF(double degreesOfFreedom) {
            super(degreesOfFreedom);
        }

        public CDF(double degreesOfFreedom, double mean, double precision) {
            super(degreesOfFreedom, mean, precision);
        }

        public CDF(StudentTDistribution other) {
            super(other);
        }

        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        public double evaluate(double input) {
            double p;
            double delta = input - this.mean;
            double a = 0.5 * BetaDistribution.CDF.evaluate(this.degreesOfFreedom / (this.degreesOfFreedom + this.precision * (delta * delta)), 0.5 * this.degreesOfFreedom, 0.5);
            if (delta < 0.0) {
                a = 1.0 - a;
            }
            if ((p = 1.0 - a) < 0.0) {
                p = 0.0;
            }
            if (p > 1.0) {
                p = 1.0;
            }
            return p;
        }

        @Override
        public Double inverse(double p) {
            return InverseTransformSampling.inverse(this, p).getInput();
        }

        @Override
        public CDF getCDF() {
            return this;
        }

        @Override
        public PDF getDerivative() {
            return this.getProbabilityFunction();
        }

        public Double differentiate(Double input) {
            return this.getDerivative().evaluate(input);
        }
    }

    public static class PDF
    extends StudentTDistribution
    implements UnivariateProbabilityDensityFunction {
        public PDF() {
        }

        public PDF(double degreesOfFreedom) {
            super(degreesOfFreedom);
        }

        public PDF(double degreesOfFreedom, double mean, double precision) {
            super(degreesOfFreedom, mean, precision);
        }

        public PDF(StudentTDistribution other) {
            super(other);
        }

        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        public double evaluate(double input) {
            return Math.exp(this.logEvaluate(input));
        }

        @Override
        public double logEvaluate(Double input) {
            return this.logEvaluate((double)input);
        }

        @Override
        public double logEvaluate(double input) {
            double logSum = 0.0;
            double v2 = this.degreesOfFreedom / 2.0;
            double delta = input - this.mean;
            logSum += MathUtil.logGammaFunction((double)(v2 + 0.5));
            logSum -= MathUtil.logGammaFunction((double)v2);
            logSum += 0.5 * Math.log(this.precision / (Math.PI * this.degreesOfFreedom));
            return logSum -= (v2 + 0.5) * Math.log(1.0 + this.precision * delta * delta / this.degreesOfFreedom);
        }

        @Override
        public PDF getProbabilityFunction() {
            return this;
        }
    }
}

