/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.MathUtil;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormSmoothUnivariateDistribution;
import gov.sandia.cognition.statistics.DistributionEstimator;
import gov.sandia.cognition.statistics.DistributionWeightedEstimator;
import gov.sandia.cognition.statistics.EstimableDistribution;
import gov.sandia.cognition.statistics.SmoothCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.UnivariateProbabilityDensityFunction;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Pair;
import gov.sandia.cognition.util.WeightedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Gamma distribution", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Gamma_distribution")
public class GammaDistribution
extends AbstractClosedFormSmoothUnivariateDistribution
implements EstimableDistribution<Double, GammaDistribution> {
    public static final double DEFAULT_SHAPE = 1.0;
    public static final double DEFAULT_SCALE = 1.0;
    private double shape;
    private double scale;

    public GammaDistribution() {
        this(1.0, 1.0);
    }

    public GammaDistribution(double shape, double scale) {
        this.setShape(shape);
        this.setScale(scale);
    }

    public GammaDistribution(GammaDistribution other) {
        this(other.getShape(), other.getScale());
    }

    @Override
    public GammaDistribution clone() {
        return (GammaDistribution)super.clone();
    }

    public double getShape() {
        return this.shape;
    }

    public void setShape(double shape) {
        if (shape <= 0.0) {
            throw new IllegalArgumentException("Shape must be > 0.0");
        }
        this.shape = shape;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Scale must be > 0.0");
        }
        this.scale = scale;
    }

    @Override
    public Double getMean() {
        return this.getShape() * this.getScale();
    }

    @Override
    public double getVariance() {
        return this.getShape() * this.getScale() * this.getScale();
    }

    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(new double[]{this.getShape(), this.getScale()});
    }

    public void convertFromVector(Vector parameters) {
        if (parameters.getDimensionality() != 2) {
            throw new IllegalArgumentException("Expected a 2-dimensional Vector!");
        }
        this.setShape(parameters.getElement(0));
        this.setScale(parameters.getElement(1));
    }

    public static ArrayList<Double> sample(double shape, double scale, Random random, int numSamples) {
        if (shape <= 0.0) {
            throw new IllegalArgumentException("Shape must be > 0.0");
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Scale must be > 0.0");
        }
        ArrayList<Double> samples = new ArrayList<Double>(numSamples);
        int k = (int)Math.floor(shape);
        double delta = shape - (double)k;
        double v0 = delta > 0.0 ? Math.exp(1.0) / (Math.exp(1.0) + delta) : 0.0;
        for (int n = 0; n < numSamples; ++n) {
            double logSum = 0.0;
            for (int i = 0; i < k; ++i) {
                double u = random.nextDouble();
                logSum += Math.log(u);
            }
            double xi = 0.0;
            if (delta > 0.0) {
                double nu = 0.0;
                int MAX_ITERATIONS = 100;
                int m = 0;
                for (m = 0; m < 100; ++m) {
                    double emxi;
                    double xidm1;
                    double vm2 = random.nextDouble();
                    double vm1 = random.nextDouble();
                    double vm0 = random.nextDouble();
                    if (vm2 < v0) {
                        xi = Math.pow(vm1, 1.0 / delta);
                        xidm1 = Math.pow(xi, delta - 1.0);
                        emxi = Math.exp(-xi);
                        nu = vm0 * xidm1;
                    } else {
                        xi = 1.0 - Math.log(vm1);
                        xidm1 = Math.pow(xi, delta - 1.0);
                        emxi = Math.exp(-xi);
                        nu = vm0 * emxi;
                    }
                    if (nu <= xidm1 * emxi) break;
                }
                if (m >= 100) {
                    throw new IllegalArgumentException("Exceeded max iterations in GammaDistribution.sample");
                }
            }
            samples.add(scale * (xi - logSum));
        }
        return samples;
    }

    @Override
    public ArrayList<Double> sample(Random random, int numSamples) {
        return GammaDistribution.sample(this.getShape(), this.getScale(), random, numSamples);
    }

    @Override
    public CDF getCDF() {
        return new CDF(this);
    }

    @Override
    public PDF getProbabilityFunction() {
        return new PDF(this);
    }

    public String toString() {
        return "Shape = " + this.getShape() + ", Scale = " + this.getScale();
    }

    @Override
    public Double getMinSupport() {
        return 0.0;
    }

    @Override
    public Double getMaxSupport() {
        return Double.POSITIVE_INFINITY;
    }

    public MomentMatchingEstimator getEstimator() {
        return new MomentMatchingEstimator();
    }

    public static class WeightedMomentMatchingEstimator
    extends AbstractCloneableSerializable
    implements DistributionWeightedEstimator<Double, GammaDistribution> {
        @Override
        public GammaDistribution learn(Collection<? extends WeightedValue<? extends Double>> data) {
            Pair pair = UnivariateStatisticsUtil.computeWeightedMeanAndVariance(data);
            return MomentMatchingEstimator.learn((Double)pair.getFirst(), (Double)pair.getSecond());
        }
    }

    public static class MomentMatchingEstimator
    extends AbstractCloneableSerializable
    implements DistributionEstimator<Double, GammaDistribution> {
        @Override
        public GammaDistribution learn(Collection<? extends Double> data) {
            Pair pair = UnivariateStatisticsUtil.computeMeanAndVariance(data);
            return MomentMatchingEstimator.learn((Double)pair.getFirst(), (Double)pair.getSecond());
        }

        public static GammaDistribution learn(double mean, double variance) {
            double scale = variance / mean;
            double shape = mean * mean / variance;
            return new GammaDistribution(shape, scale);
        }
    }

    public static class CDF
    extends GammaDistribution
    implements SmoothCumulativeDistributionFunction {
        public CDF() {
        }

        public CDF(double shape, double scale) {
            super(shape, scale);
        }

        public CDF(GammaDistribution other) {
            super(other);
        }

        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        public double evaluate(double input) {
            return CDF.evaluate(input, this.getShape(), this.getScale());
        }

        public static double evaluate(double x, double shape, double scale) {
            double p = x <= 0.0 ? 0.0 : MathUtil.lowerIncompleteGammaFunction((double)shape, (double)(x / scale));
            return p;
        }

        @Override
        public CDF getCDF() {
            return this;
        }

        @Override
        public PDF getDerivative() {
            return this.getProbabilityFunction();
        }

        public Double differentiate(Double input) {
            return this.getDerivative().evaluate(input);
        }
    }

    public static class PDF
    extends GammaDistribution
    implements UnivariateProbabilityDensityFunction {
        public PDF() {
        }

        public PDF(double shape, double scale) {
            super(shape, scale);
        }

        public PDF(GammaDistribution other) {
            super(other);
        }

        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        public double evaluate(double input) {
            return PDF.evaluate(input, this.getShape(), this.getScale());
        }

        public static double evaluate(double x, double shape, double scale) {
            double p = x > 0.0 ? Math.exp(PDF.logEvaluate(x, shape, scale)) : 0.0;
            return p;
        }

        @Override
        public double logEvaluate(Double input) {
            return this.logEvaluate((double)input);
        }

        @Override
        public double logEvaluate(double input) {
            return PDF.logEvaluate(input, this.getShape(), this.getScale());
        }

        public static double logEvaluate(double input, double shape, double scale) {
            if (input <= 0.0) {
                return Math.log(0.0);
            }
            double n1 = (shape - 1.0) * Math.log(input);
            double n2 = -input / scale;
            double d1 = MathUtil.logGammaFunction((double)shape);
            double d2 = shape * Math.log(scale);
            return n1 + n2 - d1 - d2;
        }

        @Override
        public PDF getProbabilityFunction() {
            return this;
        }
    }
}

