/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian.conjugate;

import gov.sandia.cognition.statistics.bayesian.AbstractBayesianParameter;
import gov.sandia.cognition.statistics.bayesian.BayesianParameter;
import gov.sandia.cognition.statistics.bayesian.conjugate.AbstractConjugatePriorBayesianEstimator;
import gov.sandia.cognition.statistics.distribution.GammaDistribution;

public class GammaInverseScaleBayesianEstimator
extends AbstractConjugatePriorBayesianEstimator<Double, Double, GammaDistribution, GammaDistribution> {
    public static final double DEFAULT_SHAPE = 1.0;

    public GammaInverseScaleBayesianEstimator() {
        this(1.0, new GammaDistribution());
    }

    public GammaInverseScaleBayesianEstimator(double shape, GammaDistribution prior) {
        this(new GammaDistribution(shape, 1.0), prior);
    }

    public GammaInverseScaleBayesianEstimator(GammaDistribution conditional, GammaDistribution prior) {
        this(new Parameter(conditional, prior));
    }

    protected GammaInverseScaleBayesianEstimator(BayesianParameter<Double, GammaDistribution, GammaDistribution> parameter) {
        super(parameter);
    }

    public Parameter createParameter(GammaDistribution conditional, GammaDistribution prior) {
        return new Parameter(conditional, prior);
    }

    public double getShape() {
        return ((GammaDistribution)this.parameter.getConditionalDistribution()).getShape();
    }

    public void setShape(double shape) {
        ((GammaDistribution)this.parameter.getConditionalDistribution()).setShape(shape);
    }

    @Override
    public void update(GammaDistribution belief, Double data) {
        double alpha = belief.getShape();
        double beta = 1.0 / belief.getScale();
        double theta = 1.0 / (beta += data.doubleValue());
        belief.setShape(alpha += this.getShape());
        belief.setScale(theta);
    }

    @Override
    public double computeEquivalentSampleSize(GammaDistribution belief) {
        double alpha = belief.getShape();
        return alpha / this.getShape();
    }

    public static class Parameter
    extends AbstractBayesianParameter<Double, GammaDistribution, GammaDistribution> {
        public static final String NAME = "inverse-scale";

        public Parameter(GammaDistribution conditional, GammaDistribution prior) {
            super(conditional, NAME, prior);
        }

        @Override
        public void setValue(Double value) {
            ((GammaDistribution)this.conditionalDistribution).setScale(1.0 / value);
        }

        public Double getValue() {
            return 1.0 / ((GammaDistribution)this.conditionalDistribution).getScale();
        }
    }
}

