/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.statistics.ClosedFormDistribution;
import gov.sandia.cognition.statistics.ComputableDistribution;
import gov.sandia.cognition.statistics.Distribution;
import gov.sandia.cognition.statistics.ProbabilityFunction;
import gov.sandia.cognition.statistics.bayesian.BayesianParameter;
import gov.sandia.cognition.statistics.bayesian.DefaultBayesianParameter;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import gov.sandia.cognition.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

public class BayesianUtil {
    public static <ObservationType> double logLikelihood(ComputableDistribution<? super ObservationType> distribution, Iterable<? extends ObservationType> observations) {
        ProbabilityFunction<ObservationType> f = distribution.getProbabilityFunction();
        double logSum = 0.0;
        for (ObservationType observation : observations) {
            logSum += f.logEvaluate(observation);
        }
        return logSum;
    }

    public static <ObservationType, ParameterType> ArrayList<? extends ObservationType> sample(ClosedFormDistribution<ObservationType> conditional, String parameterName, Distribution<ParameterType> prior, Random random, int numSamples) {
        DefaultBayesianParameter parameter = new DefaultBayesianParameter(conditional, parameterName, prior);
        return BayesianUtil.sample(parameter, random, numSamples);
    }

    public static <ObservationType, ParameterType> ArrayList<ObservationType> sample(BayesianParameter<ParameterType, ? extends Distribution<ObservationType>, ? extends Distribution<ParameterType>> parameter, Random random, int numSamples) {
        ArrayList<ParameterType> parameters = parameter.getParameterPrior().sample(random, numSamples);
        ArrayList samples = new ArrayList(numSamples);
        for (int n = 0; n < numSamples; ++n) {
            parameter.setValue(parameters.get(n));
            samples.add(parameter.getConditionalDistribution().sample(random));
        }
        return samples;
    }

    @PublicationReference(author={"Andrew Gelman", "John B. Carlin", "Hal S. Stern", "Donald B. Rubin"}, title="Bayesian Data Analysis, Second Edition", type=PublicationType.Book, year=2004, pages={180, 181}, notes={"Equation 6.6"})
    public static <ObservationType> double deviance(ComputableDistribution<ObservationType> conditional, Iterable<? extends ObservationType> observations) {
        return -2.0 * BayesianUtil.logLikelihood(conditional, observations);
    }

    @PublicationReference(author={"Andrew Gelman", "John B. Carlin", "Hal S. Stern", "Donald B. Rubin"}, title="Bayesian Data Analysis, Second Edition", type=PublicationType.Book, year=2004, pages={180, 181}, notes={"Equation 6.9"})
    public static <ObservationType, ParameterType> UnivariateGaussian expectedDeviance(BayesianParameter<ParameterType, ? extends ComputableDistribution<ObservationType>, ?> predictiveDistribution, Iterable<? extends ObservationType> observations, Random random, int numSamples) {
        ArrayList parameters = predictiveDistribution.getParameterPrior().sample(random, numSamples);
        ArrayList<Double> deviances = new ArrayList<Double>(parameters.size());
        for (Object parameter : parameters) {
            predictiveDistribution.setValue(parameter);
            deviances.add(BayesianUtil.deviance((ComputableDistribution)predictiveDistribution.getConditionalDistribution(), observations));
        }
        return UnivariateGaussian.MaximumLikelihoodEstimator.learn(deviances, 0.0);
    }

    public static UnivariateGaussian getMean(Collection<? extends Double> samples) {
        Pair pair = UnivariateStatisticsUtil.computeMeanAndVariance(samples);
        double mean = (Double)pair.getFirst();
        double variance = (Double)pair.getSecond() / (double)samples.size();
        return new UnivariateGaussian(mean, variance);
    }
}

