/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.statistics.CumulativeDistributionFunction;
import gov.sandia.cognition.statistics.DiscreteDistribution;
import gov.sandia.cognition.statistics.InvertibleCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.ProbabilityMassFunctionUtil;
import gov.sandia.cognition.statistics.UnivariateDistribution;
import gov.sandia.cognition.statistics.method.ConfidenceInterval;
import gov.sandia.cognition.statistics.method.InverseTransformSampling;

@PublicationReference(author={"Wikipedia"}, title="Credible interval", type=PublicationType.WebPage, year=2010, url="http://en.wikipedia.org/wiki/Credible_interval")
public class BayesianCredibleInterval
extends ConfidenceInterval {
    public BayesianCredibleInterval(double median, double lowerBound, double upperBound, double confidence) {
        super(median, lowerBound, upperBound, confidence, 1);
    }

    public static <NumberType extends Number> BayesianCredibleInterval compute(UnivariateDistribution<NumberType> distribution, double confidence) {
        double xmedian;
        double xmax;
        double xmin;
        CumulativeDistributionFunction<NumberType> cdf = distribution.getCDF();
        double pvalue = 1.0 - confidence;
        double pmin = pvalue / 2.0;
        double pmax = 1.0 - pvalue / 2.0;
        if (cdf instanceof InvertibleCumulativeDistributionFunction) {
            InvertibleCumulativeDistributionFunction icdf = (InvertibleCumulativeDistributionFunction)cdf;
            xmin = ((Number)icdf.inverse(pmin)).doubleValue();
            xmax = ((Number)icdf.inverse(pmax)).doubleValue();
            xmedian = ((Number)icdf.inverse(0.5)).doubleValue();
        } else if (cdf instanceof DiscreteDistribution) {
            xmin = ((Number)ProbabilityMassFunctionUtil.inverse(cdf, pmin).getInput()).doubleValue();
            xmax = ((Number)ProbabilityMassFunctionUtil.inverse(cdf, pmax).getInput()).doubleValue();
            xmedian = ((Number)ProbabilityMassFunctionUtil.inverse(cdf, 0.5).getInput()).doubleValue();
        } else {
            xmin = ((Number)InverseTransformSampling.inverse(cdf, pmin).getInput()).doubleValue();
            xmax = ((Number)InverseTransformSampling.inverse(cdf, pmax).getInput()).doubleValue();
            xmedian = ((Number)InverseTransformSampling.inverse(cdf, 0.5).getInput()).doubleValue();
        }
        return new BayesianCredibleInterval(xmedian, xmin, xmax, confidence);
    }
}

